<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

/**
 * 地区库
 */
class Region extends BaseAdminController
{

    /**
     * 备份接口
     */
    public function txt()
    {
        $list = \app\common\model\Region::select()
        ->toArray();

        $txt = "";

        foreach($list as $v){
            if(empty($txt)){
                $txt.="\n";
            }
            foreach($v as $k2=>$v2){
                $txt.="$k2=$v2,";
            }
            $txt.="\n";
        }
        header('Content-Type: text/plain');
        header('Content-Disposition: attachment; filename="download.txt"');
        header('Content-Type: text/plain; charset=utf-8');
        echo $txt;die;
    }

    /**
     * 地址列表查询接口
     * 先查pid==0的 依次查询下去
     */
    public function list()
    {
        $params = $this->request->get();

        $where = [];
        if(isset($params['pid'])){
            $where['parent_id']=$params['pid'];       
        }
        
        $list = \app\common\model\Region::where($where)
        ->order('level','asc')
        ->paginate(1000);
        
        // $list = linear_to_tree($list,'sub','id','parent_id');
        return show(1,'',$list);
    }


    public function create()
    {
        $params = $this->request->post();
        $res = \app\common\model\Region::create($params);
        if(!$res){
            return show(0,'添加失败');
        };
        return show(1,'添加成功');
    }

    public function del($id)
    {
        $res = \app\common\model\Region::where('id',$id)->delete();

        $id2 = $id;
        while(true){
            $a = \app\common\model\Region::where('parent_id',$id2)->find();
            if($a){
                $a->delete();
                $id2 = $a->id;
            }else{
                break;
            }
        }

        return show(1,'删除成功');
    }

    // public function dels()
    // {
    //     $ids = $this->request->post('ids');
    //     $res = \app\common\model\Region::where('id','in',$ids)->delete();
    //     if(!$res){
    //         return show(0,'批量删除失败');
    //     };
    //     return show(1,'批量删除成功');
    // }

    public function delAll()
    {
        $res = \app\common\model\Region::select()->delete();
        if(!$res){
            return show(0,'批量删除失败');
        };
        return show(1,'批量删除成功');
    }


    public function detail($id)
    {
        $res = \app\common\model\Region::where('id',$id)->find();
        if(!$res){
            return show(0,'查询失败');
        };
        return show(1,'查询成功', $res);
    }


    /**
     * 修改
     * @return void
     */
    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\Region::where('id',$params['id'])->update($params);
        if(!$res){
            return show(0,'修改失败');
        };
        return show(1,'修改成功');
    }

    /**
     * 批量添加
     */
    public function adds()
    {
        $params = $this->request->post();

        $data = explode(PHP_EOL,$params['data']);

        $add_data = [];

        foreach($data as $v){
           $item = explode(",",$v);
           $temp = [];

           foreach($item as $v2){
                $field_data = explode("=",$v2);
                if(!isset($field_data[1])){
                    continue;
                }
                $temp[$field_data[0]]=$field_data[1];
           }

           $add_data[]=$temp;           
        }        

        \app\common\model\Region::insertAll($add_data);

        return \show(\config('status.success'),'添加成功');
    }


}


