<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║
 *  ║                                                   ║
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller;

use app\common\service\ConfigService;
use app\common\service\JsonService;

class RealVerifyConfig extends BaseAdminController
{
    public function list()
    {
        return show(1, '读取成功', [
            'hide_name' => ConfigService::get('real_verify', 'hide_name', false),
            'hide_phone' => ConfigService::get('real_verify', 'hide_phone', false),
            'hide_sfz' => ConfigService::get('real_verify', 'hide_sfz', false),
            'type_1_auto_status' => ConfigService::get('real_verify', 'type_1_auto_status', 0),
            'type_1_auto_app_code' => ConfigService::get('real_verify', 'type_1_auto_app_code', ''),
            'type_2_auto_status' => ConfigService::get('real_verify', 'type_2_auto_status', 0),
            'type_2_auto_app_code' => ConfigService::get('real_verify', 'type_2_auto_app_code', '')
        ]);
    }

    public function edit()
    {
        $params = $this->request->post();

        if (isset($params['hide_name'])) {
            ConfigService::set('real_verify', 'hide_name', $params['hide_name']);
        }

        if (isset($params['hide_phone'])) {
            ConfigService::set('real_verify', 'hide_phone', $params['hide_phone']);
        }

        if (isset($params['hide_sfz'])) {
            ConfigService::set('real_verify', 'hide_sfz', $params['hide_sfz']);
        }

        if (isset($params['type_1_auto_status'])) {
            ConfigService::set('real_verify', 'type_1_auto_status', $params['type_1_auto_status']);
        }

        if (isset($params['type_1_auto_app_code'])) {
            ConfigService::set('real_verify', 'type_1_auto_app_code', $params['type_1_auto_app_code']);
        }

        if (isset($params['type_2_auto_status'])) {
            ConfigService::set('real_verify', 'type_2_auto_status', $params['type_2_auto_status']);
        }

        if (isset($params['type_2_auto_app_code'])) {
            ConfigService::set('real_verify', 'type_2_auto_app_code', $params['type_2_auto_app_code']);
        }

        return show(1, '保存成功');
    }
}