<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

/**
 * @todo 权限控制
 */
return [
    //首页
    'index'     => [
        //控制台
        'index' => [
            'page_path'     => '/index',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['workbench/index'],
            ],
        ]
    ],
    'community'     => [
        //控制台
        'article' => [
            'page_path'     => '/community/article/lists',
            'view'      => [
                'button_auth'   => ['view']
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'community.article/details',
                    'community.article/del',
                    'community.article/status'
                ]
            ]
        ],

        'circle' => [
            'page_path'     => '/community/circle/lists',
            'view'      => [
                'button_auth'   => ['view']
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'community.circle/add',
                    'community.circle/edit',
                    'community.circle/details',
                    'community.circle/del',
                    'community.circle/status'
                ]
            ]
        ],
        'topic' => [
            'page_path'     => '/community/topic/lists',
            'view'      => [
                'button_auth'   => ['view']
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'community.topic/details',
                    'community.topic/del',
                    'community.topic/status'
                ]
            ]
        ],
    ],

    //商品
    'goods'     => [
        //商品管理
        'goods'         => [
            'page_path' => '/goods/lists',
            'view'      => [//查看
                'button_auth'   => ['view'],
                'action_auth'   => ['goods.goods/lists','goods.goods/otherlist'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'goods.goods/add',
                    'goods.goods/edit',
                    'goods.goods/del',
                    'goods.goods/status',
                    'goods.goods/sort',
                    'goods.goods/export',
                ]
            ],
        ],
        //分类管理
        'category' => [
            'page_path'     => '/goods/category',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['goods.goodscategory/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'goods.category/add',
                    'goods.category/edit',
                    'goods.category/status',
                    'goods.category/del',
                ]
            ],
        ],
        //品牌管理
        'brand'    => [
            'page_path'     => '/goods/brand',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['goods.goodsbrand/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'goods.goodsbrand/add',
                    'goods.goodsbrand/edit',
                    'goods.goodsbrand/status',
                    'goods.goodsbrand/del',
                ]
            ],
        ],
        //商品单位
        'unit'     => [
            'page_path'     => '/goods/unit',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['goods.goodsunit/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'goods.goodsunit/add',
                    'goods.goodsunit/edit',
                    'goods.goodsunit/status',
                    'goods.goodsunit/del',
                ]
            ],
        ],
        //供应商管理
        'supplier'    => [//商品供应商
            'page_path'   => '/goods/supplier/lists',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['goods.goodssupplier/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'goods.goodssupplier/add',
                    'goods.goodssupplier/edit',
                    'goods.goodssupplier/del',
                ]
            ],
        ],
        //供应商分类
        'suppliercategory'    => [
            'page_path'   => '/goods/supplier/category',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['goods.goodssuppliercategory/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'goods.goodssuppliercategory/add',
                    'goods.goodssuppliercategory/edit',
                    'goods.goodssuppliercategory/del',
                ]
            ],
        ]
    ],
    //订单
    'order'     => [
        //订单管理
        'order'     => [
            'page_path'     => '/order/order',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['order.order/otherlists','order.order/lists'],
            ],
            //取消订单
            'cancel'        => [
                'button_auth'   => ['cancel'],
                'action_auth'   => ['order.order/cancel']
            ],
            //修改价格
            'changeprice'        => [
                'button_auth'   => ['changeprice'],
                'action_auth'   => ['order.order/changeprice']
            ],
            //修改运费
            'changeexpressprice'        => [
                'button_auth'   => ['changeprice'],
                'action_auth'   => ['order.order/changeexpressprice']
            ],
            //修改地址、发货
            'addressdelivery'        => [
                'button_auth'   => ['addressedit','delivery'],
                'action_auth'   => ['order.order/addressedit','order.order/delivery']
            ],
            //确认收货
            'confirm'           => [
                'button_auth'   => ['confirm'],
                'action_auth'   => ['order.order/confirm']
            ],
            'manage'        => [
                'button_auth'   => [
                    'auth_all'
                ],
                'action_auth'   => [
                    'order.order/detail',               //订单详情
                    'order.order/orderremarks',         //商家备注
                    'order.order/deliveryinfo',         //发货订单
                ]
            ],
        ],
        'aftersales'=> [
            'page_path'     => '/order/after_sales',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['after_sale.aftersale/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'order.aftersales/agree',               //同意售后
                    'order.aftersales/refuse',              //拒绝售后
                    'order.aftersales/refusegoods',         //拒绝收货
                    'order.aftersales/confirmgoods',        //确认收货
                    'order.aftersales/agreerefund',         //卖家同意退款
                    'order.aftersales/refuserefund',        //卖家拒绝退款
                    'order.aftersales/confirmrefund',       //卖家确认退款
                    'order.aftersales/detail',              //查看售后详情
                ]
            ],
        ],
    ],
    //用户
    'user'      => [
        //用户概述
        'profile'   => [
            'page_path'     => '/user/profile',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['user.user/index'],
            ],
        ],
        //用户管理
        'list'      => [
            'page_path'     => '/user/lists',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['user.user/lists','user.user/otherlist'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'user.user/detail',             //用户详情
                    'user.user/info',               //用户信息
                    'user.user/setinfo',            //设置用户信息
                    'user.user/setlabel',           //设置批量标签
                    'user.user/setuserlabel',       //设置用户标签
                ]
            ],
            'adjustaccount' => [
                'button_auth'   => [
                    'adjustuserwallet'
                ],
                'action_auth'   => [
                    'user.user/adjustuserwallet'
                ],
            ],
        ],
        //用户等级
        'userlevel' => [
            'page_path'     => '/user/grade',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['user.userlevel/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'user.userlevel/add',
                    'user.userlevel/edit',
                    'user.userlevel/detail',
                    'user.userlevel/del',
                ]
            ],
        ],
        //用户等级
        'userlabel' => [
            'page_path'     => '/user/tag',
            'view'      => [
                'button_auth'  => ['view'],
                'action_auth'  => ['user.userlabel/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'user.userlabel/add',
                    'user.userlabel/edit',
                    'user.userlabel/detail',
                    'user.userlabel/del',
                ]
            ],
        ],
    ],
    //营销
    'marketing' => [
        //应用中心
        'marketing' => [
            'page_path'     => '/marketing/index',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['config/getmarketingmodule'],
            ],
        ],
        //营销中心
        'marketingapp' => [
            'page_path'     => '/application/app',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['config/getappmodule'],
            ],
        ],
        //充值概览
        'rechargesurvey'   => [
            'page_path'     => '/recharge/survey',
            'view'          => [
                'button_auth'   => ['view'],
                'action_auth'   => ['recharge.recharge/datacenter'],
            ]
        ],
        //充值规则
        'rechargerule'   => [
            'page_path'     => '/recharge/rule',
            'view'          => [
                'button_auth'   => ['view'],
                'action_auth'   => ['recharge.recharge/getconfig'],
            ],
            'save'          => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['recharge.recharge/setconfig'],
            ],
        ],
        //充值记录
        'rechargerecord'    => [
            'page_path'     => '/recharge/record',
            'view'          => [
                'button_auth'   => ['view'],
                'action_auth'   => ['recharge.recharge/lists'],
            ],
        ],
        
        //业务通知
        'notice'   => [
            'page_path'     => [
                '/sms/seller',
                '/sms/buyers/buyers',
                '/sms/buyers/business',
            ],
            'view'          => [
                'button_auth'   => ['view'],
                'action_auth'   => ['notice.notice/settinglists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'notice.notice/detail',
                    'notice.notice/set',
                ],
            ],
        ],
        //短信设置
        'smssetting'   => [
            'page_path'     => '/sms/sms',
            'view'          => [
                'button_auth'   => ['view'],
                'action_auth'   => ['notice.smsconfig/getconfig'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'notice.smsconfig/detail',
                    'notice.smsconfig/setconfig',
                ],
            ],
        ],

        //签到概览
        'calendarsurvey'   => [
            'page_path'     => '/calendar/survey',
            'view'          => [
                'button_auth'   => ['view'],
                'action_auth'   => ['sign.sign/datacenter'],
            ]
        ],
        //签到规则
        'calendarrule'   => [
            'page_path'     => '/calendar/rule',
            'view'          => [
                'button_auth'   => ['view'],
                'action_auth'   => ['sign.sign/getconfig'],
            ],
            'save'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['sign.sign/setconfig'],
            ],
        ],
        //签到记录
        'calendarrecord'    => [
            'page_path'     => '/calendar/record',
            'view'          => [
                'button_auth'   => ['view'],
                'action_auth'   => ['sign.sign/lists'],
            ],
        ],
                
    ],
    //财务
    'finance'   => [
        //财务概况
        'profile'   => [
            'page_path'     => '/finance/profile',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['finance.finance/datacenter'],
            ],
        ],
        //余额明细
        'accountlog'   => [
            'page_path'     => '/finance/account_log',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['accountlog/lists','accountlog/getchangetype'],
            ],
        ],

    ],

    //渠道
    'channel'   => [
        //微信公众号设置
        'oasetting'   => [
            'page_path'     => '/channel/mp_wechat/index',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['wechat.officialaccountsetting/getconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['wechat.officialaccountsetting/setConfig'],
            ],
        ],
        //微信菜单设置
        'oamenu'   => [
            'page_path'     => '/channel/mp_wechat/menu',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['wechat.officialaccountmenu/detail'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['wechat.officialaccountsetting/saveandpublish'],
            ],
        ],
        //关注回复
        'oafollowreply'   => [
            'page_path'     => ['/channel/mp_wechat/reply/follow_reply','/channel/mp_wechat/reply/keyword_reply','/channel/mp_wechat/reply/default_reply'],
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['wechat.officialaccountreply/lists'],
            ],
            'manage'        => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'wechat.officialaccountreply/add',
                    'wechat.officialaccountreply/edit',
                    'wechat.officialaccountreply/status',
                    'wechat.officialaccountreply/detail',
                    'wechat.officialaccountreply/del',
                ]
            ],
        ],
        //小程序设置
        'mpsetting'   => [
            'page_path'     => '/channel/wechat_app/wechat_app',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['wechat.miniprogramsetting/getconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['wechat.miniprogramsetting/setconfig'],
            ],
        ],
        //APP设置
        'appsetting'   => [
            'page_path'     => '/channel/app_store/app_store',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.app.appsetting/getconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.app.appsetting/setconfig'],
            ],
        ],
        //H5设置
        'h5setting'   => [
            'page_path'     => '/channel/h5_store/h5_store',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.h5.hfivesetting/getconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.h5.appsetting/setconfig'],
            ],
        ],
        //pc商城-渠道设置
        'pcstore'   => [
            'page_path'     => '/channel/pc_store/index',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['pc.pcsetting/getconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['pc.pcsetting/setconfig'],
            ],
        ],

    ],
    //设置
    'setting'   => [
        //店铺信息
        'shop'      => [
            'page_path'     => '/setting/shop/shop',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.shop.shopsetting/getshopinfo'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.shop.shopsetting/setconfig'],
            ],
        ],
        //备案信息
        'record'      => [
            'page_path'     => '/setting/shop/record',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.shop.shopsetting/getrecordinfo'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.shop.shopsetting/setrecordinfo'],
            ],
        ],
        //分享信息
        'share'     => [
            'page_path'     => '/setting/shop/share',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.shop.shopsetting/getsharesetting'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.shop.shopsetting/setsharesetting'],
            ],
        ],
        //政策协议
        'protocol'     => [
            'page_path'     => '/setting/shop/protocol',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.shop.shopsetting/getpolicyagreement'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.shop.shopsetting/setpolicyagreement'],
            ],
        ],
        //支付方式
        'paymethod'     => [
            'page_path'     => '/setting/payment/pay_method',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.pay.payway/getpayway'],
            ],
            'save'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.pay.payway/setpayway'],
            ],
        ],
        //支付配置
        'payconfig'     => [
            'page_path'     => '/setting/payment/pay_config',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.pay.payconfig/lists'],
            ],
            'edit'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'settings.pay.payway/getconfig',
                    'settings.pay.payway/setconfig',
                ],
            ],
        ],
        //配送方式
        'delivery'      => [
            'page_path'     => '/setting/delivery/index',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.delivery.deliveryway/getconfig'],
            ],
            'manage'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'settings.delivery.deliveryway/setconfig',
                    'settings.delivery.freight/lists',
                    'settings.delivery.freight/add',
                    'settings.delivery.freight/edit',
                    'settings.delivery.freight/del',
                    'settings.delivery.express/lists',
                    'settings.delivery.express/add',
                    'settings.delivery.express/edit',
                    'settings.delivery.express/del',
                    'settings.delivery.logisticsconfig/getlogisticsconfig',
                    'settings.delivery.logisticsconfig/setlogisticsconfig',
                ],
            ],
        ],
        //管理员
        'permissions'   => [
            'page_path'     => '/setting/permissions/admin',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['auth.admin/lists','auth.role/lists'],
            ],
            'manage'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'auth.admin/add',
                    'auth.admin/edit',
                    'auth.admin/detail',
                    'auth.admin/del',
                ],
            ],

        ],
        //角色
        'role'          => [
            'page_path'     => '/setting/permissions/role',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['auth.role/lists'],
            ],
            'manage'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'auth.role/add',
                    'auth.role/edit',
                    'auth.role/detail',
                    'auth.role/getMenu',
                    'auth.role/del',
                ],
            ],
        ],
        //商品设置
        'goods'         => [
            'page_path'     => '/setting/goods/goods',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.goods.goodssettings/getconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.goods.goodssettings/setconfig'],
            ],
        ],
        //用户设置
        'user'          => [
            'page_path'     => '/setting/user/user_setting',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.user.user/getconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.user.user/setconfig'],
            ],
        ],
        //登录注册
        'loginregister' => [
            'page_path'     => '/setting/user/login_register',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.user.user/getregisterconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.user.user/setregisterconfig'],
            ],
        ],
        //订单设置
        'order'             => [
            'page_path'     => '/setting/order/order',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.order.transaction_settings/getconfig'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.order.transaction_settings/setconfig'],
            ],
        ],
        //储存设置
        'storage'           => [
            'page_path'     => '/setting/storage/index',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.shop.storage/lists'],
            ],
            'manage'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => [
                    'settings.order.storage/change',
                    'settings.shop.storage/index',
                    'settings.shop.storage/setup'
                ],
            ],
        ],
        //系统日志
        'systemlog'     => [
            'page_path'     => '/setting/system_maintain/journal',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.system.log/lists'],
            ],
        ],
        //系统缓存
        'systemcache'     => [
            'page_path'     => '/setting/system_maintain/cache',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => [],
            ],
            'clear'     => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.system.cache/clear'],
            ],
        ],
        //异常日志
        'errorlog'     => [
            'page_path'     => '/setting/system_maintain/error_journal',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => [],
            ],
        ],
        //计划任务
        'task'     => [
            'page_path'     => '/setting/task',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['crontab.crontab/lists'],
            ],
            'manage'    => [
                'button_auth'   => ['view'],
                'action_auth'   => [
                    'crontab.crontab/add',
                    'crontab.crontab/edit',
                    'crontab.crontab/operate',
                    'crontab.crontab/del',
                ],
            ],
        ],
        //地图配置
        'map'             => [
            'page_path'     => '/setting/map',
            'view'      => [
                'button_auth'   => ['view'],
                'action_auth'   => ['settings.shop.shop_setting/getMapKey'],
            ],
            'save'      => [
                'button_auth'   => ['auth_all'],
                'action_auth'   => ['settings.shop.shop_setting/setMapKey'],
            ],
        ],
    ],
];
