<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║
 *  ║                                                   ║
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
declare (strict_types=1);

namespace app\common\model;

use think\Model;

/**
 * @mixin \think\Model
 */
class Report extends Model
{
    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id')->field('id,nickname,avatar');
    }

    public function category()
    {
        return $this->hasOne(ReportCategory::class, 'id', 'category_id');
    }

    public function getCategoriesAttr()
    {
        $result = [];

        $category = $this->category;

        while (true) {
            $result[] = $category;

            if ($category->pid) {
                $category = ReportCategory::find($category->pid);

                if (!$category) {
                    break;
                }
            } else {
                break;
            }
        }

        return array_reverse($result);
    }

    public function getItemAttr()
    {
        switch ($this->reported_content_type) {
            case 'twoshop':
                return TwoGoods::where('id', $this->reported_content_id)->with('user')->find();
            case 'shop':
                // TODO
            case 'circle':
                return Circle::where('id', $this->reported_content_id)->find();
            case 'article':
                return Article::where('id', $this->reported_content_id)->find();
            case 'group':
                return ChatGroup::where('id', $this->reported_content_id)->find();
            case 'user':
                return User::where('id', $this->reported_content_id)->find();
        }

        return null;
    }
}
