<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;


use app\common\service\FileService;

class PayWay extends BaseModel
{
    protected $name = 'dev_pay_way';

    public function getIconAttr($value,$data)
    {
        return FileService::getFileUrl($value);
    }

    /**
     * @notes 支付方式名称获取器
     * @param $value
     * @param $data
     * @return mixed
     */
    public static function getPayWayNameAttr($value,$data)
    {
        return PayConfig::where('id',$data['dev_pay_id'])->value('name');
    }

    /**
     * @notes 关联支配配置模型
     * @return \think\model\relation\HasOne
     */
    public function payConfig()
    {
        return $this->hasOne(PayConfig::class,'id','dev_pay_id');
    }
}