<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;


use think\model\concern\SoftDelete;

class GoodsSupplier extends BaseModel
{
    use SoftDelete;
    protected $deleteTime = 'delete_time';

    /**
     * @notes 供应商分类名称获取器
     * @param $value
     * @param $data
     * @return mixed
     */
    public function getSupplierCategoryAttr($value,$data)
    {
        return GoodsSupplierCategory::where('id',$data['supplier_category_id'])->value('name');
    }

    /**
     * @notes 一对多关联商品模型
     * @return \think\model\relation\HasMany
     */
    public function goods()
    {
        return $this->hasMany(Goods::class,'supplier_id','id');
    }
}