<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\enum\AfterSaleEnum;
use app\common\service\FileService;
use think\model\concern\SoftDelete;
use app\common\model\User;

/**
 * 售后类
 * Class AfterSale
 * @package app\common\model
 */
class AfterSale extends BaseModel
{
    use SoftDelete;


    /**
     * @notes 关联售后商品模型
     * @return \think\model\relation\HasOne
     */
    public function afterSaleGoods()
    {
        return $this->hasMany(AfterSaleGoods::class, 'after_sale_id', 'id')
            ->field('after_sale_id, order_goods_id as goods_snap');
    }

    /**
     * @notes 售后类型获取器
     * @param $value
     * @return string
     */
    public function getRefundTypeDescAttr($value)
    {
        $desc = [1 => '整单退款', 2 => '商品售后'];

        return $desc[$value] ?? '';
    }

    /**
     * @notes 售后方式获取器
     * @param $value
     * @return string
     */
    public function getRefundMethodDescAttr($value)
    {
        $desc = [1 => '仅退款', 2 => '退货退款'];

        return $desc[$value] ?? '';
    }

    /**
     * @notes 获取售后状态描述
     * @param $value
     * @return string
     */
    public function getStatusDescAttr($value)
    {
        return AfterSaleEnum::getStatusDesc($value);
    }

    /**
     * @notes 获取售后子状态描述
     * @param $value
     * @return string
     */
    public function getSubStatusDescAttr($value)
    {
        return AfterSaleEnum::getSubStatusDesc($value);
    }

    /**
     * @notes 商品编码搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchGoodsInfoAttr($query, $value, $data)
    {
        if(!isset($data['goods_info']) || empty($data['goods_info'])) {
            return false;
        }
        $goodsId = Goods::where('name|code', 'like', '%'.$data['goods_info'].'%')->value('id');
        $afterSaleIds = AfterSaleGoods::where('goods_id', $goodsId)->column('after_sale_id');
        $query->where('as.id', 'in', $afterSaleIds);
    }

    /**
     * @notes 凭证修改器
     * @param $voucher
     * @return false|string
     */
    public function setVoucherAttr($voucher)
    {
        foreach($voucher as &$value) {
            FileService::setFileUrl($value);
        }
        if (empty($voucher)) {
            return '';
        }
        return json_encode($voucher, JSON_UNESCAPED_UNICODE);
    }

    /**
     * @notes 凭证获取器
     * @param $voucher
     * @return mixed|string
     */
    public function getVoucherAttr($voucher)
    {
        return empty($voucher) ? '' : json_decode($voucher, true);
    }

    public function getExpressNameAttr($value)
    {
        return empty($value) ? '-' : $value;
    }

    public function getInvoiceNoAttr($value)
    {
        return empty($value) ? '-' : $value;
    }

    public function getExpressTimeAttr($value)
    {
        return empty($value) ? '-' : date('Y-m-d H:i:s');
    }
}