<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\listener\websocket;


use app\common\enum\ChatEnum;

use app\common\model\User;
use app\common\model\Admin;
use app\common\websocket\Response;

/**
 * 登录事件
 * Class Login
 * @package app\common\listener\websocket
 */
class Login
{

    protected $response;

    public function __construct(Response $response)
    {
        $this->response = $response;
    }


    public function handle(array $event)
    {
        
        ['token' => $token,'type'=>$type] = $event;
        
        if($type == 'user'){
            return $this->userLogin($token);
        }else if($type == 'kefu'){
            return $this->adminLogin($token);
        }

        
    }

    public function adminLogin($token)
    {
        if (empty($token)) {
            return $this->response->error('参数缺失');
        }

        // 查询用户信息
        $user = Admin::alias('u')
        ->field(['u.id',  'name', 'avatar', 'account','s.token'])
        ->join('admin_session s', 'u.id = s.admin_id')
        ->where(['s.token' => $token])
        ->findOrEmpty();

        if ($user->isEmpty()) {
            return $this->response->error('用户信息不存在或用户已被禁用');
        }

        // echo '<pre>';print_r($this->response->success('', $user->toArray()));die;

        return $this->response->success('', $user->toArray());
    }
    

    public function userLogin($token)
    {
        if (empty($token)) {
            return $this->response->error('参数缺失');
        }

        // 查询用户信息
        $user = User::alias('u')
        ->field(['u.id', 'sn', 'nickname', 'avatar', 'mobile', 'level', 'group_id', 'disable', 's.token'])
        ->join('user_session s', 'u.id = s.user_id')
        ->where(['s.token' => $token])
        ->findOrEmpty();

        if ($user->isEmpty() || $user['disable']) {
            return $this->response->error('用户信息不存在或用户已被禁用');
        }
        $user_arr = $user->toArray();
        if(!strstr('http',$user['avatar'])){
            $user_arr['avatar'] = '/'.$user_arr['avatar'];
        }

        // echo '头像-----------------';
        // echo $user_arr['avatar'];die;
        
        return $this->response->success('', $user_arr);
    }

}