<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\enum;

/**
 * 提现枚举
 * Class WithdrawEnum
 * @package app\common\enum
 */
class WithdrawEnum
{
    /**
     * 默认值
     */
    const DEFAULT_MIN_MONEY = 0;
    const DEFAULT_MAX_MONEY = 100;
    const DEFAULT_PERCENTAGE = 10;
    const DEFAULT_TYPE = [self::TYPE_BALANCE];

    /**
     * 提现类型
     */
    const TYPE_BALANCE = 1;         //余额
    const TYPE_WECHAT_CHANGE = 2;   //微信零钱
    const TYPE_WECHAT_CODE = 4;     //微信收款码
    const TYPE_ALI_CODE = 5;        //阿里收款码
    const TYPE_BANK = 3;            //银行卡


    /**
     * 提现状态
     */
    const STATUS_WAIT = 1;
    const STATUS_ING = 2;
    const STATUS_SUCCESS = 3;
    const STATUS_FAIL = 4;


    /**
     * 微信零钱提现方式
     */
    const ENTERPRISE = 1;//企业付款到零钱
    const MERCHANT = 2;//商家转账到零钱

    /**
     * @notes 获取提现类型描述
     * @param $type
     * @param false $flag
     * @return string|string[]
     */
    public static function getTypeDesc($type, $flag = false)
    {
        $desc = [
            self::TYPE_BALANCE => '钱包余额',
            self::TYPE_WECHAT_CHANGE => '微信零钱',
            self::TYPE_WECHAT_CODE => '微信收款码',
            self::TYPE_ALI_CODE => '支付宝收款码',
            self::TYPE_BANK => '银行卡',
        ];
        if($flag) {
            return $desc;
        }
        return $desc[$type] ?? '';
    }

    /**
     * @notes 获取状态描述
     * @param $status
     * @param false $flag
     * @return string|string[]
     */
    public static function getStatusDesc($status, $flag = false)
    {
        $desc = [
            self::STATUS_WAIT => '待提现',
            self::STATUS_ING => '提现中',
            self::STATUS_SUCCESS => '提现成功',
            self::STATUS_FAIL => '提现失败',
        ];
        if($flag) {
            return $desc;
        }
        return $desc[$status] ?? '';
    }
}
