<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\enum;

/**
 * 用户标签枚举类
 * Class UserLabelEnum
 * @package app\common\enum
 */
class UserLabelEnum
{

    const MANUAL_LABEL  = 0;
    const AUTO_LABEL    = 1;

    /**
     * @notes 获取标签类型
     * @param bool $from
     * @return array|mixed|string
     */
    public static function getLabelTypeDesc($from  = true){
        $desc = [
            self::MANUAL_LABEL  => '手动标签',
            self::AUTO_LABEL    => '自动标签',
        ];
        if(true === $from){
            return $desc;
        }
        return $desc[$from] ?? '';
    }
}
