<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\logic;

use app\common\logic\BaseLogic;
use app\common\service\ConfigService;
use app\common\service\WeChatConfigService;
use EasyWeChat\Factory;
use EasyWeChat\Kernel\Exceptions\Exception;

/**
 * 微信逻辑层
 * Class WechatLogic
 * @package app\api\logic
 */
class WechatLogic extends BaseLogic
{
    /**
     * @notes 微信JSSDK授权接口
     * @param $params
     * @return array|false|string
     * @throws \EasyWeChat\Kernel\Exceptions\InvalidArgumentException
     * @throws \EasyWeChat\Kernel\Exceptions\InvalidConfigException
     * @throws \EasyWeChat\Kernel\Exceptions\RuntimeException
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public static function jsConfig($params)
    {
        try {
//            $config = [
//                'app_id' => ConfigService::get('official_account','app_id'),
//                'secret' => ConfigService::get('official_account','app_secret')
//            ];
            $config = WeChatConfigService::getOaConfig();
            $app = Factory::officialAccount($config);
            $url = urldecode($params['url']);
            $app->jssdk->setUrl($url);
            $apis = [
                'onMenuShareTimeline',
                'onMenuShareAppMessage',
                'onMenuShareQQ',
                'onMenuShareWeibo',
                'onMenuShareQZone',
                'openLocation',
                'getLocation',
                'chooseWXPay',
                'updateAppMessageShareData',
                'updateTimelineShareData',
                'openAddress',
                'scanQRCode'
            ];

            $data = $app->jssdk->getConfigArray($apis, $debug = false, $beta = false);

            return $data;
        } catch (Exception |\think\Exception $e) {

            self::setError('公众号配置出错:' . $e->getMessage());
            return false;
        }
    }
}