<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\logic;

use app\api\lists\ChatRecordLists;
use app\api\lists\ChatMessageLists;
use app\api\lists\ChatPrivateMessageLists;
use app\api\lists\ChatGroupMessageLists;
use app\common\{
    logic\BaseLogic
};
use app\common\model\User;

/**
 * 用户聊天
 * Class ChatLogic
 * @package app\api\logic
 */
class ChatLogic extends BaseLogic
{
    /**
     * @notes 获取与接收方聊天记录
     * @param $userId
     * @return array
     * @date 2022/3/14 14:47
     */
    // public static function getChatRecord($userId,$receiveId): array
    // {
    //     // 聊天记录
    //     $records = (new ChatRecordLists());
    //     $records = [
    //         'lists' => $records->private_chat_list($receiveId),
    //         'count' => $records->count(),
    //         'page_no' => $records->pageNo,
    //         'page_size' => $records->pageSize,
    //         'more' => is_more($records->count(), $records->pageNo,  $records->pageSize)
    //     ];

    //     // 接收方
    //     $receive = User::where(['id' => $receiveId])
    //         ->field(['id', 'nickname', 'avatar'])
    //         ->findOrEmpty();

    //     return ['receive' => $receive, 'record' => $records];
    // }

    /**
     * 获取私聊聊天记录
     */
    public static function getChatPrivateMessage($userId,$to_id)
    {
        // 聊天记录
        $messages = (new ChatMessageLists());
        $messages = $messages->chat_private_list($userId,$to_id);

        // 接收方
        $user = User::where(['id' => $to_id])
            ->field(['id', 'nickname', 'avatar'])
            ->findOrEmpty();

        // 触发已读
        \app\common\model\ChatTemp::where([
            "user_id"=>$userId,
            'to_id'=>$to_id,
        ])
        ->update(['unread'=>0]);

        return ['user' => $user, 'messages' => $messages];
    }

    /**
     * 获取客服聊天内容
     */
    public static function getChatKefuMessage($userId,$to_id)
    {
        // 聊天记录
        $messages = (new ChatMessageLists());
        $messages = $messages->chat_kefu_list($userId,$to_id);

        // 接收方
        $user = User::where(['id' => $to_id])
            ->field(['id', 'nickname', 'avatar'])
            ->findOrEmpty();

        // 触发已读
        \app\common\model\ChatTemp::where([
            "user_id"=>$userId,
            'to_id'=>$to_id,
        ])
        ->update(['unread'=>0]);

        return ['user' => $user, 'messages' => $messages];
    }

    /**
     * 获取群聊聊天记录
     */
    public static function getChatGroupMessage($userId,$group_id)
    {
        // $userId判断用户是否在群里有查询权限
        $is = \app\common\model\ChatGroupMember::where([
            ['user_id','=',$userId],
            ['group_id','=',$group_id]
        ])->find();
        if(!$is){
            throw new \think\Exception('无权限查看记录');
        }
        // 聊天记录
        $messages = (new ChatMessageLists());
        $messages = $messages->chat_group_list($group_id);

        foreach($messages as &$v){
            if($v->msg_type == 'red'){
                // 判断你有没有领取过这个红包
                foreach($v->redPackets->redPackets->records as &$v2){
                    if($v2['receiv_user_id'] == $userId || $v->redPackets->redPackets->send_user_id == $userId){
                        //已领取
                        $v['have_red']=1;
                        break;
                    }else{
                        $v['have_red']=0;
                    } 
                    unset($v->redPackets->redPackets->records);
                };
            }
        }

        // 触发已读
        \app\common\model\ChatTemp::where([
            "user_id"=>$userId,
            'group_id'=>$group_id,
        ])
        ->update(['unread'=>0]);

        return ['messages' => $messages];

    }





}