<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\lists\ListsSearchInterface;
use app\common\model\Topic;
use app\common\server\FileServer;
use app\common\service\ConfigService;
use app\common\service\FileService;

class TopicLists extends BaseShopDataLists implements ListsSearchInterface
{
    /**
     * @notes 设置搜索
     * @return \string[][]
     */
    public function setSearch(): array
    {
        return [
            '%like%' => ['name'],
        ];
    }

    /**
     * @notes 圈子列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $params = input();
        $where = [];
        if(isset($params['is_recommend'])){
            $where[]=[
                'is_recommend','=',$params['is_recommend'],
            ];
        }
        $lists = Topic::where($this->searchWhere)
        ->where($where)
            ->order('sort desc,id desc')
            ->limit($this->limitOffset, $this->limitLength)
            ->field('id,name,synopsis,longitude,latitude,address,hot')
            ->select()
            ->toArray();

        foreach($lists as  &$item){
            $item['icon'] = FileService::getFileUrl(ConfigService::get('shop', 'mobile_logo'));
        }

        return $lists;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        return Topic::where($this->searchWhere)->count();
    }
}