<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\enum\DeliveryEnum;
use app\common\enum\OrderEnum;
use app\common\enum\TeamEnum;
use app\common\model\Order;


class OrderLists extends BaseShopDataLists
{

    /**
     * @notes 列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $lists = Order::withSearch(['order_type', 'user_id'], [
                'order_type' => $this->params['type'],
                'user_id' => $this->userId
            ])
            ->with(['order_goods' => function ($query) {
                $query->field('goods_id,order_id,goods_snap,goods_name,goods_price,goods_num,is_comment,original_price')
                    ->append(['goods_image', 'spec_value_str'])
                    ->hidden(['goods_snap']);
            }])
            ->field(['id', 'sn', 'order_type', 'order_status', 'total_num', 'order_amount', 'delivery_type', 'is_team_success', 'pay_status', 'express_status','delivery_content', 'create_time'])
            ->append(['btn'])
            ->order(['id' => 'desc'])
            ->limit($this->limitOffset, $this->limitLength)
            ->select()->toArray();

        foreach ($lists as &$list){
            //订单状态描述
            $list['order_status_desc'] = OrderEnum::getOrderStatusDesc($list['order_status']);
            //订单类型
            $list['order_type_desc'] =  OrderEnum::getOrderTypeDesc($list['order_type']);
            // 判断是否评论
            $commentRecord = \app\common\model\GoodsComment::where([
                ['user_id','=',$this->userId],
                ['order_id','=',$list['id']],
            ])->find();
            if($commentRecord){
                $list['is_comment']=1;
            }else{
                $list['is_comment']=0;
            }    
    
        }

        return $lists;
    }


    /**
     * @notes 数量
     * @return int
     */
    public function count(): int
    {
        return Order::withSearch(['order_type', 'user_id'], [
            'order_type' => $this->params['type'],
            'user_id' => $this->userId
        ])->count();
    }
}