<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;


use app\common\model\CircleCate;

class CircleCateList extends BaseShopDataLists  
{
    protected $withJoin = [];
    /**
     * @notes 设置搜索
     * @return \string[][]
     */
    public function setSearch()
    {
         
        if (isset($this->params['name'])  && $this->params['name']) {
            $this->searchWhere[] = [
                'name' , 'like' ,'%'.$this->params['name'].'%'
            ];
        }

        // 指定用户下的
        if (isset($this->params['type'])  && $this->params['type'] =='user') {
            $this->withJoin = [
                'user_circle'
            ];
            $this->searchWhere[] = [
                'user_id' , '=' ,$this->userId
            ];
        }


        // 指定用户下的
        if (isset($this->params['type'])  && $this->params['type'] =='home') {
            $this->searchWhere[] = [
                'home_show' , '=' ,1
            ];
        }

    }

    /**
     * @notes 圈子列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $this->setSearch();
        $lists = CircleCate::withJoin($this->withJoin)
        ->where('is_show',1)
        ->where($this->searchWhere)
            ->order('sort desc,id desc')
            ->limit($this->limitOffset, $this->limitLength)
            ->append(['collect_num'])
            ->select()
            ->toArray();

        foreach($lists as  &$item){

            $item['create_time'] = formatTime($item['create_time']);
        }

        return $lists;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        $this->setSearch();
        return CircleCate::withJoin($this->withJoin)->where($this->searchWhere)->count();
    }
}