<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\logic\ChatLogic;
use app\common\model\ChatMessage;
use app\common\model\ChatPrivateMessage;
use app\common\model\ChatGroupMessage;
use app\common\model\ChatRecord;

/**
 * 用户聊天记录列表
 * Class ChatRecordLists
 * @package app\api\lists
 */
class ChatMessageLists extends BaseShopDataLists
{

    /**
     * @notes 设置查询条件
     * @return array[]
     * @date 2022/3/14 14:48
     */
    public function setWhere(): array
    {
        $map1 = [
            ['from_id', '=', $this->userId],
        ];
        $map2 = [
            ['to_id', '=', $this->userId],
        ];
        return [$map1, $map2];
    }


    /**
     * @notes 聊天记录列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     * @date 2022/3/14 14:48
     */
    public function lists(): array
    {
        // $lists = ChatMessage::whereOr($this->setWhere())
        //     ->order('id desc')
        //     ->limit($this->limitOffset, $this->limitLength)
        //     ->select()->toArray();

        // if (!empty($lists)) {
        //     $lists = ChatLogic::formatChatRecords($lists);
        // }

        // return $lists;
    }

    /**
     * 私聊聊天记录
     */
    public function chat_private_list($user_id,$to_id)
    {
        $where1 = [
            ['from_id','=',$user_id],
            ['to_id','=',$to_id]
        ];
        $where2 = [
            ['to_id','=',$user_id],
            ['from_id','=',$to_id]
        ];
        $lists = ChatPrivateMessage::with(['transfers','redPackets'])
            ->whereOr([$where1,$where2])
            ->order('id desc')
            ->limit($this->limitOffset, $this->limitLength)
            ->paginate();

        foreach($lists as &$v){
            if($v['msg_type']=='article'){
                $v['article'] = \app\common\model\Article::field('title,content,image')->find($v['msg']);
            }elseif($v['msg_type']=='goods'){
                $v['goods'] = \app\common\model\Article::field('name,image,min_price,content')->find($v['msg']);
            }elseif($v['msg_type']=='twoshop_goods'){
                $v['goods'] = \app\common\model\TwoGoods::find($v['msg']);
            }elseif($v['msg_type']=='twoshop_order'){
                $v['order'] = \app\common\model\TwoOrder::find($v['msg']);
            }
        }

        return $lists;
    }

    /**
     * 客服聊天记录
     */
    public function chat_kefu_list($user_id,$to_id)
    {
        $where1 = [
            ['from_id','=',$user_id],
            ['to_id','=',$to_id]
        ];
        $where2 = [
            ['to_id','=',$user_id],
            ['from_id','=',$to_id]
        ];
        $lists = ChatMessage::where('type','kefu_chat')
        ->whereOr([$where1,$where2])
        ->order('id desc')
        ->limit($this->limitOffset, $this->limitLength)
        ->paginate();

        foreach($lists as &$v){
            if($v['msg_type']=='article'){
                $v['article'] = \app\common\model\Article::field('title,content,image')->find($v['msg']);
            }elseif($v['msg_type']=='goods'){
                $v['goods'] = \app\common\model\Article::field('name,image,min_price,content')->find($v['msg']);
            }
        }
        return $lists;
    }

     /**
     * 群聊天记录
     */
    public function chat_group_list($group_id)
    {
        $lists = ChatGroupMessage::with(['fromUser','redPackets'])
        ->where('group_id',$group_id)
        ->order('id desc')
        ->limit($this->limitOffset, $this->limitLength)
        ->paginate();

        foreach($lists as &$v){
            if($v['msg_type']=='article'){
                $v['article'] = \app\common\model\Article::field('title,content,image')->find($v['msg']);
            }elseif($v['msg_type']=='goods'){
                $v['goods'] = \app\common\model\Article::field('name,image,min_price,content')->find($v['msg']);
            }
        }

        return $lists;
    }


    /**
     * @notes 记录数量
     * @return int
     * @date 2022/3/14 14:49
     */
    public function count($type=''): int
    {
        // if($type == 'group'){
        //     return ChatGroupMessage::whereOr($this->setWhere())->count();
        // }elseif($type == 'private'){
        //     return ChatPrivateMessage::whereOr($this->setWhere())->count();
        // }
        return 0;
    }
}