<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\model\ArticleComment;
use app\common\model\UserCollect;

class ArticleCommentsLists extends BaseShopDataLists  
{
    /**
     * @notes 设置搜索
     * @return \string[][]
     */
    public function setSearch()
    {
        
        $this->searchWhere = [];
        $this->searchWhere[] = [
            'status' ,'=' , 1
        ];
        
        if (isset($this->params['article_id'])  && $this->params['article_id'] ) {
            $this->searchWhere[] = [
                'aid' ,'=' , $this->params['article_id']
            ];
        }

        
        
    }

    /**
     * @notes 圈子列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $sort = input('sort');
        // dd($sort);
        $order = ['is_pin'=>'desc'];
        if($sort && !empty($sort)){
            if($sort=='hot'){
                $order['star_num']='desc';
                $order['create_time']='desc';
            }else if($sort == 'asc'){
                $order['create_time']='asc';
            }else if($sort == 'desc'){
                $order['create_time']='desc';
            }
        }else{
            $order=['star_num'=>'desc','create_time'=>'desc'];
        }
        
        $pid = input('pid');
        $pid = isset($pid)?$pid:0;
        
        $this->setSearch();
        // dd($this->searchWhere);

        $with = ['user','replyUser'];
        if(isActivePluginByPluginName('shop')){
            $with[]='goods';
        }
        
        $lists = ArticleComment::with($with)->where($this->searchWhere)
            ->where(['pid' => $pid])
            ->order($order)
            ->append(['collect_num'])
            ->limit($this->limitOffset, $this->limitLength)
            ->select()
            ->toArray();
        
        
            $max_word_len_ellipsis = \app\common\service\ConfigService::get('article', 'max_word_len_ellipsis',60);
            $min_word_len_ellipsis = \app\common\service\ConfigService::get('article', 'min_word_len_ellipsis',26);

        $first = \app\common\model\ArticleComment::where($this->searchWhere)->order('id','asc')->find();

        foreach($lists as  &$item){
            
            if($item['id'] == $first->id){
                $item['is_first']=1;
            }else{
                $item['is_first']=0;
            }

            // 查询出@的好友用户信息
            if(!empty($item['msg_user_ids'])){
                $msg_user_ids_arr = explode(',',$item['msg_user_ids']);
                foreach($msg_user_ids_arr as $v){
                    $item['msg_users'][] = \app\common\model\User::field('id,nickname,avatar')->find($v);
                }
            }

            $item['create_time'] = formatTime($item['create_time']);

            // 截取字符串
            $item['is_content_more']=0;
            $item['require_more']=0;
            if(!strstr($item['comment'],'http') && mb_strlen($item['comment'],'UTF-8')>$max_word_len_ellipsis){
                $item['require_more']=1;
                $item['is_content_more']=1;
                $item['content_more_content'] = $item['comment'];
                $item['comment'] = mb_substr($item['comment'],0,$min_word_len_ellipsis,'UTF-8');
            }
            
            if($this->userId) {
                //是否点赞过
                $isCollect = UserCollect::where([ 'type' => 3, 'comments_id' => $item['id'], 'aid' => $item['aid'], 'user_id' => $this->userId])->value('id');
                $item['is_collect'] = $isCollect ? 1 : 0;
            }

            if($pid==0){
                // 获取子评论
                $replyList = ArticleComment::with(['user','replyUser'])->where($this->searchWhere)
                ->where(['pid' => $item['id']])
                ->order($order)
                ->append(['collect_num'])
                ->limit($this->limitOffset, $this->limitLength)
                ->select()
                ->toArray();
                foreach($replyList as &$ritem){

                    // dd($ritem);
                    // 查询出@的好友用户信息
                    if(!empty($ritem['msg_user_ids'])){
                        $msg_user_ids_arr = explode(',',$ritem['msg_user_ids']);
                        foreach($msg_user_ids_arr as $v){
                            $ritem['msg_users'][] = \app\common\model\User::field('id,nickname,avatar')->find($v);
                        }
                    }

                    // 截取字符串
                    $ritem['is_content_more']=0;
                    $ritem['require_more']=0;
                    if(!strstr($ritem['comment'],'http') && mb_strlen($ritem['comment'],'UTF-8')>$max_word_len_ellipsis){
                        $ritem['require_more']=1;
                        $ritem['is_content_more']=1;
                        $ritem['content_more_content'] = $ritem['comment'];
                        $ritem['comment'] = mb_substr($ritem['comment'],0,$min_word_len_ellipsis,'UTF-8');
                    }

                    $ritem['create_time'] = formatTime($ritem['create_time']);

                    if($this->userId) {
                        //是否点赞过
                        $isCollect = UserCollect::where([ 'type' => 3, 'comments_id' => $ritem['id'], 'aid' => $ritem['aid'], 'user_id' => $this->userId])->value('id');
                        $ritem['is_collect'] = $isCollect ? 1 : 0;
                    }
                }
                $item['replyList'] = [
                    'list'=>$replyList,
                    'count'=> ArticleComment::where(['pid' => $item['id']])->count()
                ];
            }
            

        }

        

        return $lists;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        $this->setSearch();
        return ArticleComment::where($this->searchWhere)->where(['pid' => 0])->count();
    }
}