<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;


use app\common\enum\FileEnum;
use app\common\service\UploadService;
use app\common\validate\UploadValidate;
use Exception;
use think\response\Json;

class Upload extends BaseShopController
{
    /**
     * @notes 用户图片上传
     * @return Json
     */
    public function image()
    {
        (new UploadValidate())->goCheck(null,['image'=>$this->request->file()]);
        try {
            $result = UploadService::image(0, $this->userId,FileEnum::SOURCE_USER);
            return $this->success('上传成功', $result);
        } catch (Exception $e) {
            return $this->fail($e->getMessage());
        }
    }

     /**
     * @notes 上传视频
     * @return Json
     */
    public function video()
    {
        (new UploadValidate())->goCheck('null',['video'=>$this->request->file()]);

        try {
           
            $result = UploadService::video(0);
            return $this->success('上传成功', $result);
        } catch (Exception $e) {
            return $this->fail($e->getMessage());
        }
    }

    /**
     * @notes 附件上传
     * @return Json
     */
    public function file()
    {
        (new UploadValidate())->goCheck('null',['attachment'=>$this->request->file()]);

        try {
            $result = UploadService::file(0);
            return $this->success('上传成功', $result);
        } catch (Exception $e) {
            return $this->fail($e->getMessage());
        }
    }
}

// 收费价格：输入框浮点数据
// 内容免费阅读字数：输入框整数
// 图片免费观看个数：整数
// 视频收费：


