<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\validate\settings\user;
use app\common\model\UserLevel;
use app\common\validate\BaseValidate;

/**
 * 用户设置验证
 * Class UserConfigValidate
 * @package app\adminapi\validate\settings\user
 */
class UserConfigValidate extends BaseValidate
{
    protected $regex = ['money'=>'/^[0-9]+(.[0-9]{1,2})?$/'];

    protected $rule = [
        'register_way'              => 'requireIf:scene,register|array',
        'login_way'                 => 'requireIf:scene,register|array',
        'is_mobile_register_code'   => 'requireIf:scene,register|in:0,1',
        'coerce_mobile'             => 'requireIf:scene,register|in:0,1',
        'h5_wechat_auth'            => 'in:0,1',
        'h5_auto_wechat_auth'       => 'in:0,1',
        'mnp_wechat_auth'           => 'in:0,1',
        'mnp_auto_wechat_auth'      => 'in:0,1',
        'app_wechat_auth'           => 'in:0,1',
        'withdraw_way'              => 'requireIf:scene,withdraw|array',
        'withdraw_min_money'        => 'gt:0|regex:money|lt:withdraw_max_money',
        'withdraw_max_money'        => 'gt:0|regex:money',
        'withdraw_service_charge'   => 'egt:0|regex:money|lt:100',
        'default_avatar'            => 'require',
        'default_user_home_bj'      => 'require',
        'invite_open'               => 'require|in:0,1',
        'invite_ways'               => 'require|in:1,2',
        'invite_appoint_user'       => 'array|checkAppointUser',
        'invite_condition'          => 'require|in:1',
        'wechat_default_login_way'  => 'requireIf:scene,register|in:1,2,3',
        'h5_default_login_way'      => 'requireIf:scene,register|in:1,2,3',
        'app_default_login_way'     => 'requireIf:scene,register|in:1,2,3',
    ];
    protected $message = [
        'default_avatar.require'            => '请上传用户默认头像',
        'default_user_home_bj.require'      => '请上传用户主页背景图片',
        'register_way.requireIf'            => '请选择注册方式',
        'register_way.array'                => '注册方式值错误',
        'login_way.requireIf'               => '请选择登录方式',
        'login_way.array'                   => '登录方式值错误',
        'is_mobile_register_code.requireIf' => '请选择手机号码注册需验证码',
        'is_mobile_register_code.in'        => '手机号码注册需验证码错误',
        'coerce_mobile.requireIf'           => '请选择注册强制绑定手机',
        'coerce_mobile.in'                  => '注册强制绑定手机值错误',
        'h5_wechat_auth.in'                 => '公众号微信授权登录值错误',
        'h5_auto_wechat_auth.in'            => '公众号微信授权登录值错误',
        'mnp_wechat_auth.in'                => '小程序授权登录值错误',
        'app_wechat_auth.in'                => '小程序微信授权登录值错误',
        'withdraw_way.requireIf'            => '请选择提现方式',
        'withdraw_way.in'                   => '提现方式值错误',
        'withdraw_min_money.gt'             => '最低提现金额不能小于零',
        'withdraw_min_money.regex'          => '最低提现金额只能是大于零的数字,且保留两位小数',
        'withdraw_min_money.lt'             => '最低提现金额不能大于最高提现金额',
//        'withdraw_min_money.require'        => '请输入最低提现金额',
        'withdraw_max_money.gt'             => '最高提现金额不能小于零',
        'withdraw_max_money.regex'          => '最高提现金额只能是大于零的数字,且保留两位小数',
//        'withdraw_max_money.require'        => '请输入最高提现金额',
        'withdraw_service_charge.egt'       => '提现手续费不能小于零',
        'withdraw_service_charge.regex'     => '提现手续费只能是大于零的数字,且保留两位小数',
        'withdraw_service_charge.lt'        => '提现手续费不能大于等于100',
    ];

    //用户设置验证
    public function sceneUser()
    {
        return $this->only(['default_avatar','default_user_home_bj']);
    }

    //注册验证
    public function sceneRegister()
    {
        return $this->only(['register_way','login_way','is_mobile_register_code','coerce_mobile','h5_wechat_auth','h5_auto_wechat_auth','mnp_wechat_auth','mnp_auto_wechat_auth','app_wechat_auth','wechat_default_login_way','h5_default_login_way','app_default_login_way']);
    }

    //提现验证
    public function sceneWithdraw()
    {
        return $this->only(['withdraw_way','withdraw_min_money','withdraw_max_money','withdraw_service_charge']);
    }

    //验证会员等级
    public function checkAppointUser($value,$rule,$data){
        if(0 == $data['invite_open']){
            return true;
        }
        if(1 == $data['invite_ways']){
            return true;
        }
        if(empty($value)){
            return '请选择指定用户';
        }
        $userLevel = UserLevel::column('id');
        foreach ($value as $id){
            if(!in_array($id,$userLevel)){
                return '用户等级错误，请刷新页面';
            }
        }
        return true;
    }

}