<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate\settings\shop;


use app\common\validate\BaseValidate;

class StorageValidate extends BaseValidate
{
    protected $rule = [
        'engine' => 'require',
        'status' => 'require',
    ];

    /**
     * @notes 设置存储参数
     * @return StorageValidate
     */
    public function sceneSetup()
    {

        return $this->only(['engine', 'status']);
    }

    /**
     * @notes 获取配置参数信息
     * @return StorageValidate
     */
    public function sceneIndex()
    {

        return $this->only(['engine']);
    }

    /**
     * @notes 切换默认存储引擎
     * @return StorageValidate
     */
    public function sceneChange()
    {

        return $this->only(['engine']);
    }
}