<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\logic\user;
use app\common\{
    model\UserLabel,
    model\UserLabelIndex
};

/**
 * 标签逻辑层
 * Class UserLabelLogic
 * @package app\adminapi\logic\user
 */
class UserLabelLogic
{

    /**
     * @notes 新增用户标签
     * @param array $params
     * @return bool
     */
    public function add(array $params)
    {
        $userLable = new UserLabel();
        $userLable->name            = $params['name'];
        $userLable->remark          = $params['remark'];
        $userLable->label_type      = $params['label_type'];
        $userLable->save();
        return true;

    }

    /**
     * @notes 标签详情
     * @param int $id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail(int $id)
    {

        return UserLabel::field('id,name,remark,label_type')->find($id)->toArray();

    }

    /**
     * @notes 编辑用户标签
     * @param array $params
     * @return bool
     */
    public function edit(array $params)
    {

        $updateData = [
            'id'            => $params['id'],
            'name'          => $params['name'],
            'remark'        => $params['remark'],
            'label_type'    => $params['label_type'],
        ];
        UserLabel::update($updateData);
        return true;
    }

    /**
     * @notes 删除标签
     * @param int $ids
     * @return bool
     */
    public function del(array $ids)
    {
        UserLabel::destroy($ids);
        UserLabelIndex::where(['label_id'=>$ids])->delete();
        return UserLabel::destroy($ids);
    }




}