<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\logic\settings\order;

use app\common\logic\BaseLogic;
use app\common\service\ConfigService;

/**
 * 交易设置逻辑层
 * Class TransactionSettingsLogic
 * @package app\adminapi\logic\settings\order
 */
class TransactionSettingsLogic extends BaseLogic
{
    /**
     * @notes 获取交易设置
     * @return array
     */
    public static function getConfig()
    {
        $config = [
            'cancel_unpaid_orders' => ConfigService::get('transaction', 'cancel_unpaid_orders'),
            'cancel_unpaid_orders_times' => ConfigService::get('transaction', 'cancel_unpaid_orders_times'),
            'cancel_unshipped_orders' => ConfigService::get('transaction', 'cancel_unshipped_orders'),
            'cancel_unshipped_orders_times' => ConfigService::get('transaction', 'cancel_unshipped_orders_times'),
            'automatically_confirm_receipt' => ConfigService::get('transaction', 'automatically_confirm_receipt'),
            'automatically_confirm_receipt_days' => ConfigService::get('transaction', 'automatically_confirm_receipt_days'),
            'after_sales' => ConfigService::get('transaction', 'after_sales'),
            'after_sales_days' => ConfigService::get('transaction', 'after_sales_days'),
            'inventory_occupancy' => ConfigService::get('transaction', 'inventory_occupancy'),
            'return_inventory' => ConfigService::get('transaction', 'return_inventory'),
            'return_coupon' => ConfigService::get('transaction', 'return_coupon'),
        ];

        return $config;
    }

    /**
     * @notes 交易设置
     * @param $params
     */
    public static function setConfig($params)
    {
        ConfigService::set('transaction', 'cancel_unpaid_orders', $params['cancel_unpaid_orders']);
        ConfigService::set('transaction', 'cancel_unshipped_orders', $params['cancel_unshipped_orders']);
        ConfigService::set('transaction', 'automatically_confirm_receipt', $params['automatically_confirm_receipt']);
        ConfigService::set('transaction', 'after_sales', $params['after_sales']);
        ConfigService::set('transaction', 'inventory_occupancy', $params['inventory_occupancy']);
        ConfigService::set('transaction', 'return_inventory', $params['return_inventory']);
        ConfigService::set('transaction', 'return_coupon', $params['return_coupon']);

        if(isset($params['cancel_unpaid_orders_times'])) {
            ConfigService::set('transaction', 'cancel_unpaid_orders_times', $params['cancel_unpaid_orders_times']);
        }

        if(isset($params['cancel_unshipped_orders_times'])) {
            ConfigService::set('transaction', 'cancel_unshipped_orders_times', $params['cancel_unshipped_orders_times']);
        }

        if(isset($params['automatically_confirm_receipt_days'])) {
            ConfigService::set('transaction', 'automatically_confirm_receipt_days', $params['automatically_confirm_receipt_days']);
        }

        if(isset($params['after_sales_days'])) {
            ConfigService::set('transaction', 'after_sales_days', $params['after_sales_days']);
        }
    }
}