<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\user;

use app\adminapi\{
    logic\user\UserLabelLogic,
    controller\BaseAdminController,
    validate\user\UserLableValidate,
};

class UserLabel extends BaseAdminController
{
    /**
     * @notes 等级标签列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists();
    }


    /**
     * @notes 新增用户标签
     * @return \think\response\Json
     */
    public function add()
    {
        $params = (new UserLableValidate())->post()->goCheck('add');
        (new UserLabelLogic)->add($params);
        return $this->success('添加标签成功', [], 1, 1);


    }

    /**
     * @notes 获取用户标签
     * @return \think\response\Json
     */
    public function detail()
    {
        $id = $this->request->get('id');
        $detail = (new UserLabelLogic())->detail($id);
        return $this->success('',$detail);
    }


    /**
     * @notes 编辑用户标签
     * @return \think\response\Json
     */
    public function edit()
    {
        $params = (new UserLableValidate())->post()->goCheck('edit');
        (new UserLabelLogic())->edit($params);
        return $this->success('修改标签成功', [], 1, 1);

    }

    /**
     * @notes 删除标签
     * @return \think\response\Json
     */
    public function del(){
        $params = (new UserLableValidate())->post()->goCheck('del');
        (new UserLabelLogic())->del($params['ids']);
        return $this->success('删除成功');
    }
}