<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\shop;


use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\settings\shop\ShopStorageLogic;
use app\adminapi\validate\settings\shop\StorageValidate;
use app\common\service\ConfigService;
use think\facade\Cache;
use think\response\Json;

/**
 * 存储设置控制器
 * Class StorageController
 * @package app\adminapi\controller\settings\shop
 */
class Storage extends BaseAdminController
{

    /**
     * @notes 存储引擎列表
     * @return Json
     */
    public function lists()
    {

        return $this->success('获取成功', ShopStorageLogic::lists());
    }

    /**
     * @notes 存储配置信息
     * @return Json
     */
    public function index(): Json
    {
        $param = (new StorageValidate())->get()->goCheck('index');
        return $this->success('获取成功', ShopStorageLogic::index($param));
    }

    /**
     * @notes 设置存储参数
     */
    public function setup(): Json
    {

        $params = (new StorageValidate())->post()->goCheck('setup');
        $result = ShopStorageLogic::setup($params);
        if($result === true){
            return $this->success('配置成功',[],1,1);
        }else{
            return $this->success($result,[],1,1);
        }
    }

    /**
     * @notes 切换存储方式
     */
    public function change(): Json
    {

        $params = (new StorageValidate())->post()->goCheck('change');
        ShopStorageLogic::change($params);
        return $this->success('切换成功');
    }
}
