<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\settings\index;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\settings\shop\ShopSettingLogic;

/**
 * 首页公告内容设置
 * Class TransactionSettingsController
 * @package app\adminapi\controller\settings\order
 */
class Notice extends BaseAdminController
{
    /**
     * @notes 
     * @return \think\response\Json
     */
    public function getConfig()
    {
        
        $result = \app\common\service\ConfigService::get('index', 'notice','');
        return show(1,'',$result);
    }

    /**
     * @notes 设置弹窗
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = $this->request->post();
        \app\common\service\ConfigService::set('index', 'notice', $params['notice'] ?? '');
        return $this->success('设置成功');
    }
}