<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\delivery;


use app\adminapi\controller\BaseAdminController;
use app\adminapi\lists\settings\delivery\FreightLists;
use app\adminapi\logic\settings\delivery\FreightLogic;
use app\adminapi\validate\settings\delivery\FreightValidate;

class Freight extends BaseAdminController
{
    /**
     * @notes 添加运费模版
     * @return \think\response\Json
     */
    public function add()
    {
        $params = (new FreightValidate())->post()->goCheck('add');
        $result = (new FreightLogic())->add($params);
        if (true !== $result) {
            return $this->fail($result);
        }
        return $this->success('添加成功',[],1,1);
    }

    /**
     * @notes 查看运费模版列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists(new FreightLists());
    }

    /**
     * @notes 编辑运费模版
     * @return \think\response\Json
     */
    public function edit()
    {
        $params = (new FreightValidate())->post()->goCheck('edit');
        $result = (new FreightLogic())->edit($params);
        if (true !== $result) {
            return $this->fail($result);
        }
        return $this->success('修改成功',[],1,1);
    }

    /**
     * @notes 查看运费模版详情
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail()
    {
        $params = (new FreightValidate())->goCheck('detail');
        $result = (new FreightLogic())->detail($params);
        return $this->success('获取成功',$result);
    }

    /**
     * @notes 删除运费模版
     * @return \think\response\Json
     */
    public function del()
    {
        $params = (new FreightValidate())->post()->goCheck('del');
        (new FreightLogic())->del($params);
        return $this->success('删除成功',[],1,1);
    }
}