<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect;

use app\adminapi\controller\BaseAdminController;

/**
 * 商家分类/商业数据采集
 * Class UserController
 * @package app\adminapi\controller\user
 */
class MerchantVIPCollect extends BaseAdminController
{
    // DZ-西瓜/分类行业数据采集
    public function insertDZXG()
    {
        $list = $this->request->post('list');
        $page = $this->request->post('page');

        $saveData=[];
        foreach($list as $v){
            $saveData[]=[
                "id"=>$v['id'],
                "name"=>$v['name'],
                "icon"=>$v['icon'],
                "join_price"=>$v['price'],
                "permissions"=>$v['access'],
                "desc"=>$v['desc'],
                "available_days"=>0,
                "money_date"=>0,
                "handle_money_rate"=>0,
                "publish_money_rate"=>0,
                "daily_publish_limit"=>0,
                "sort"=>0,
                "top_money_list"=>$v['dig_price'],
                "available_time_display"=>"",
            ];
        }

        // dd($saveData);

        try{
            $res = \think\facade\Db::name('merchant_vip_level')
            ->extra('IGNORE')
            ->insertAll($saveData);

            // 记录当前页数 用于下次断点采集
            \app\common\service\ConfigService::set('MerchantVIPCollect','dz_page',$page);

            return \show(1,'导入成功');
        }catch(\Exception $e){
            return \show(0,'导入失败'.$e->getMessage());
        }
        
    }


    // 查询上一次采集到第几页
    public function dzPageRecord()
    {
        $page=\app\common\service\ConfigService::get('MerchantVIPCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

    public function dzPageRecordDel()
    {
        $page=\app\common\service\ConfigService::set('MerchantVIPCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

}