<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\adminapi\controller;

class Tj extends BaseAdminController
{
    // public array $notNeedLogin = ['index','list'];

    public function index()
    {

        // 用户数据：今日昨日新增 今日活跃 本月新增 总用户数
        $total_user = \app\common\model\User::count();//总用户
        // 今日凌晨时间戳 本月起始时间戳
        $total_user_today = \app\common\model\User::where('create_time','>',strtotime('today'))
        ->count();//今日新增
        $total_user_yesterday = \app\common\model\User::where('create_time','>',strtotime('yesterday 00:00:00'))
        ->where('create_time','<',strtotime('today'))
        ->count();//昨日新增圈子
        $total_user_month = \app\common\model\User::where('create_time','>',strtotime('first day of this month 00:00:00'))
        ->count();//本月新增
        $total_user_active = \app\common\model\User::where('login_time','>',strtotime('today'))
        ->count();//今日活跃
        $total_user_acticle_yesterday = \app\common\model\User::where('login_time','>',strtotime('yesterday 00:00:00'))
        ->where('login_time','<',strtotime('today'))
        ->count();//昨日活跃

        // 圈子数据：今日昨日新增文章  累计话题 累计评论
        $article_total = \app\common\model\Article::count();
        $topic_total = \app\common\model\Topic::count();
        $article_comment_total = \app\common\model\ArticleComment::count();
        $circle_total = \app\common\model\Circle::count();
        
        $total_article_today = \app\common\model\User::where('create_time','>',strtotime('today'))
        ->count();//今日新增文章
        $total_article_yesterday = \app\common\model\User::where('create_time','>',strtotime('yesterday 00:00:00'))
        ->where('create_time','<',strtotime('today'))
        ->count();//
        
        $total_topic_today = \app\common\model\Topic::where('create_time','>',strtotime('today'))
        ->count();//今日新增文章
        $total_topic_yesterday = \app\common\model\Topic::where('create_time','>',strtotime('yesterday 00:00:00'))
        ->where('create_time','<',strtotime('today'))
        ->count();//昨日新增文章

        $total_comment_today = \app\common\model\ArticleComment::where('create_time','>',strtotime('today'))
        ->count();//今日新增评论
        $total_comment_yesterday = \app\common\model\ArticleComment::where('create_time','>',strtotime('yesterday 00:00:00'))
        ->where('create_time','<',strtotime('today'))
        ->count();//昨日新增评论

        $total_circle_today = \app\common\model\Circle::where('create_time','>',strtotime('today'))
        ->count();//今日新增圈子
        $total_circle_yesterday = \app\common\model\Circle::where('create_time','>',strtotime('yesterday 00:00:00'))
        ->where('create_time','<',strtotime('today'))
        ->count();//昨日新增圈子

        // 待审核文章
        $article_to = \app\common\model\Article::where('status',0)->count();
        // 待审核圈子
        $circle_to = \app\common\model\Circle::where('status',0)->count();
        
        // 代办事项：待审核文章 
        $data=[
            'user'=>[
                'total'=>$total_user,
                'total_today'=>$total_user_today,
                'total_month'=>$total_user_month,
                'total_active'=>$total_user_active,
                'total_yesterday'=>$total_user_yesterday,
                'total_acticle_yesterday'=>$total_user_acticle_yesterday,
            ],

            'circle'=>[
                'article_total'=>$article_total,
                'topic_total'=>$topic_total,
                'article_comment_total'=>$article_comment_total,
                'circle_total'=>$circle_total,
                'total_article_today'=>$total_article_today,
                'total_article_yesterday'=>$total_article_yesterday,
                'total_comment_today'=>$total_comment_today,
                'total_comment_yesterday'=>$total_comment_yesterday,
                'total_circle_today'=>$total_circle_today,
                'total_circle_yesterday'=>$total_circle_yesterday,
                'total_topic_today'=>$total_topic_today,
                'total_topic_yesterday'=>$total_topic_yesterday,
            ],

            'todo'=>[
                'article'=>$article_to,
                'circle'=>$circle_to
            ]
            
        ];
        return show(1,'',$data); 
    }


    /**
     * 图表统计列表
     */
    public function list($num=10)
    {
        // 文章访问
        $article = [];
        // 圈子访问
        $circle = [];
        // 话题访问
        $topic = [];
        // 评论量
        $comment = [];

        // 当天时间戳
        $today_time = strtotime('today')+60*60*24;
        
        for($i=0;$i<$num;$i++){
            $time1 = $today_time - ($i+1)*60*60*24;
            $time2 =$today_time - $i*60*60*24;

            // 文章访问
            $article[]=[
                'time'=>$time1,
                'num'=>\app\common\model\ArticleVisit::where([
                    ['create_time','>',$time1],
                    ['create_time','<',$time2],
                ])
                ->count()
                ];

            // 评论量
            $comment[]=[
                'time'=>$time1,
                'num'=>\app\common\model\ArticleComment::where([
                    ['create_time','>',$time1],
                    ['create_time','<',$time2],
                ])
                ->count()
            ];
        }

        $data = [
            'article'=>$article,
            'comment'=>$comment,
        ];

        return show(1,'',$data);
        
    }
    
}