<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║
 *  ║                                                   ║
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller;

class RealVerifyType extends BaseAdminController
{
    public function list()
    {
        $params = $this->request->param();
        $where=[];

        if (isset($params['filter'])) {
            if ($params['filter'] == 'fixed') {
                $where[] = ['type', '!=', 'NULL'];
            }

            if ($params['filter'] == 'custom') {
                $where[] = ['type', '=', null];
            }
        }

        $list = \app\common\model\RealVerifyType::where($where)
            ->with(['fields'])
            ->select()
            ->toArray();


        return show(1, '', $list);
    }

    public function create()
    {
        $params = $this->request->post();
        $res = \app\common\model\RealVerifyType::create($params);
        if (!$res) {
            return show(0, '添加失败');
        };
        return show(1, '添加成功');
    }

    public function save()
    {
        $params = $this->request->post();
        $res = \app\common\model\RealVerifyType::where('type', $params['type'])->findOrEmpty();
        if ($params['type'] == 1) {
            $data = [
                'type' => 1,
                'name' => $params['name'] ?? '个人认证',
                'icon' => $params['icon'] ?? '',
                'status' => $params['status'] ?? 0
            ];
        }
        if ($params['type'] == 2) {
            $data = [
                'type' => 2,
                'name' => $params['name'] ?? '企业认证',
                'icon' => $params['icon'] ?? '',
                'status' => $params['status'] ?? 0
            ];
        }
        if ($res->isExists()) {
            \app\common\model\RealVerifyType::where('type', $params['type'])->update($data);
        } else {
            $res = \app\common\model\RealVerifyType::create($data);
        }
        \app\common\model\RealVerifyTypeField::where('real_veify_type_id', $res->id)->where('is_bundle', 1)->delete();
        if ($params['type'] == 1) {
            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '姓名',
                'type' => '文本类型',
                'require' => 1,
                'is_bundle' => 1
            ]);

            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '电话号码',
                'type' => '文本类型',
                'require' => 1,
                'is_bundle' => 1
            ]);

            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '身份证号码',
                'type' => '文本类型',
                'require' => 1,
                'is_bundle' => 1
            ]);

            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '身份证正面',
                'type' => '身份证正面',
                'require' => 1,
                'is_bundle' => 1
            ]);

            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '身份证反面',
                'type' => '身份证反面',
                'require' => 1,
                'is_bundle' => 1
            ]);
        }
        if ($params['type'] == 2) {
            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '企业名称',
                'type' => '文本类型',
                'require' => 1,
                'is_bundle' => 1
            ]);

            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '统一信用代码或注册号',
                'type' => '文本类型',
                'require' => 1,
                'is_bundle' => 1
            ]);

            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '法人名称',
                'type' => '文本类型',
                'require' => 1,
                'is_bundle' => 1
            ]);

            \app\common\model\RealVerifyTypeField::create([
                'real_veify_type_id' => $res->id,
                'key' => '营业执照',
                'type' => '图片类型',
                'require' => 1,
                'is_bundle' => 1
            ]);
        }
        if (!$res) {
            return show(0, '失败');
        };
        return show(1, '成功');
    }

    public function del($id)
    {
        \app\common\model\RealVerifyType::destroy($id);

        return show(config('status.success'), '删除成功');
    }

    public function detail($id)
    {
        $res = \app\common\model\RealVerifyType::where('id', $id)
            ->with(['fields'])
            ->find();
        if (!$res) {
            return show(0, '查询失败');
        };
        $data = $res->toArray();
        return show(1, '查询成功', $data);
    }


    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\RealVerifyType::where('id', $params['id'])->update($params);
        if (!$res) {
            return show(0, '修改失败');
        };
        return show(1, '修改成功');
    }
}