<?php

namespace app\adminapi\controller;

class FakeUser extends BaseAdminController
{
    public function list()
    {
        $list = (new \app\common\model\User)->queryFake()
            ->with('fakeUserOwner')
            ->where('is_fake_user', 1)
            ->select()
            ->toArray();

        return show(1, '', $list);
    }

    public function create()
    {
        $params = $this->request->post();

        $res = \app\common\model\User::find($params['id']);
        $res->id = null;
        $res->sn = null;
        $res->nickname = $params['name'];
        $res->avatar = $params['avatar'];
        $res->is_fake_user = true;
        $res->fake_user_owner_id = $params['id'];

        if (isset($params['is_admin'])) {
            $res->is_fake_admin = $params['is_admin'];
        }

        $res = \app\common\model\User::create($res);

        if (!$res) {
            return show(0, '添加失败');
        };
        return show(1, '添加成功');
    }

    public function del($id)
    {
        (new \app\common\model\User)->queryFake()
            ->where('is_fake_user', 1)
            ->destroy($id);

        return show(config('status.success'), '删除成功');
    }

    public function detail($id)
    {
        $res = (new \app\common\model\User)->queryFake()
            ->with('fakeUserOwner')
            ->where('is_fake_user', 1)
            ->where('id', $id)
            ->find();
        if (!$res) {
            return show(0, '查询失败');
        };
        return show(1, '查询成功', $res);
    }


    public function update()
    {
        $params = $this->request->post();
        $res = (new \app\common\model\User)->queryFake()
            ->where('is_fake_user', 1)
            ->where('id', $params['id'])
            ->update($params);
        if (!$res) {
            return show(0, '修改失败');
        };
        return show(1, '修改成功');
    }
}