<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

use app\adminapi\lists\ArticleCommentLists;
use app\adminapi\lists\CircleLists;
use app\adminapi\lists\CircleCateLists;
use app\adminapi\lists\TopicLists;
use app\adminapi\validate\ArticleValidate;
use app\adminapi\logic\ArticleLogic;
use app\adminapi\logic\CircleLogic;
use app\adminapi\logic\CircleCateLogic;
use app\adminapi\logic\TopicLogic;
use app\common\enum\NoticeEnum;


class Article extends BaseAdminController
{

    /**
     * @notes 查看文章/帮助列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists();
    }

    /**
     * 待审核帖子数量
     */
    public function pendingProcessing()
    {
        $count = \app\common\model\Article::where('status',0)->count();
        return show(config('status.success'),['count'=>$count]);
    }

    /**
     * 待审核帖子数量
     */
    public function pendingProcessingCircle()
    {
        $count = \app\common\model\Circle::where('status',0)->count();
        return show(config('status.success'),['count'=>$count]);
    }


    /**
     * @notes 查看文章/帮助详情
     * @return \think\response\Json
     */
    public function detail()
    {
        $params = (new ArticleValidate())->goCheck('detail');
        $result = ArticleLogic::detail($params);
        return $this->data($result);
    }

    /** 编辑文章/帮助
     * @notes
     * @return \think\response\Json
     */
    public function edit()
    {
        // $params = (new ArticleValidate())->post()->goCheck('edit');
        $params = $this->request->post();
        ArticleLogic::edit($params);
        return $this->success('编辑成功',[],1,1);
    }

    /** 
     * 添加文章
     * @notes
     * @return \think\response\Json
     */
    public function add()
    {
        $params = $this->request->post();
        if(isset($params['image'])){
            $params['image'] = implode(',',$params['image']);
        }
        $res = ArticleLogic::add($params);
        return $this->success('添加成功',[],1,1);
    }

    /**
     * @notes 删除文章/帮助
     * @return \think\response\Json
     */
    public function delete()
    {
        $params = (new ArticleValidate())->post()->goCheck('delete');
        ArticleLogic::delete($params);
        return $this->success('删除成功',[],1,1);
    }

    /**
     * @notes 修改审核状态
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function status()
    {
        $params = (new ArticleValidate())->post()->goCheck('status');
        ArticleLogic::status($params);

        $article = \app\common\model\Article::where('id',$params['id'])->find()->toArray();
        
        // 拒审系统通知
        if($params['status']==2){
            event('Notice', [
                'scene_id' => NoticeEnum::ARTICLE_EXAMINE_NOTICE,
                'params' => [
                    'type'=>'article',
                    'user_id'    => $article['user_id'],  //帖子对应的发布者ID
                    'article_id' => $params['id'],   //回复的帖子,
                    'content'    => '您的内容存在违规已拒审',
                ]
            ]);
            \app\common\model\Article::update(['examine_msg'=>'您的内容存在违规管理员拒审'],['id'=>$params['id']]);
        }elseif($params['status']==1){
            event('Notice', [
                'scene_id' => NoticeEnum::ARTICLE_EXAMINE_NOTICE,
                'params' => [
                    'type'=>'article',
                    'user_id'    => $article['user_id'],  //帖子对应的发布者ID
                    'article_id' => $params['id'],   //回复的帖子,
                    'content'    => '您发布的帖子审核通过',
                ]
            ]);
        }

        return $this->success('修改成功',[],1,1);
    }

    /**
     * 评价列表
     */ 
    public function comment_lists(){
        return $this->dataLists(new ArticleCommentLists());
    }

    /**
     * 删除评价
     */ 
    public function comment_delete()
    {
        $params = $this->request->post();
        ArticleLogic::comment_delete($params);
        return $this->success('删除成功',[],1,1);
    }

    

    /**
     * 话题列表
     */ 
    public function topic_lists(){
        return $this->dataLists(new TopicLists());
    }

    public function topic_add(){
        $params = $this->request->post();
        \app\common\model\Topic::create($params);

        return show(1,'添加成功');
    }

    /**
     * 话题评价
     */ 
    public function topic_delete()
    {
        $params = $this->request->post();
        TopicLogic::delete($params);
        return $this->success('删除成功',[],1,1);
    }

    /**
     * 话题详情
     */ 
    public function topic_detail()
    {
        $params = $this->request->get();
        $result = TopicLogic::detail($params);
        return $this->data($result);
    }

    /** 编辑话题
     * @notes
     * @return \think\response\Json
     */
    public function topic_edit()
    {
        $params = $this->request->post();
        TopicLogic::edit($params);
        return $this->success('编辑成功',[],1,1);
    }


    /**
     * 圈子列表
     */ 
    public function circle_lists(){
        return $this->dataLists(new CircleLists());
    }

    public function circle_cate_lists(){
        return $this->dataLists(new CircleCateLists());
    }


    /**
     * @notes 查看详情
     * @return \think\response\Json
     */
    public function circle_detail()
    {
        $params = $this->request->get();
        $result = CircleLogic::detail($params);
        return $this->data($result);
    }

    /**
     * @notes 查看详情
     * @return \think\response\Json
     */
    public function circle_cate_detail()
    {
        $params = $this->request->get();
        $result = CircleCateLogic::detail($params);
        return $this->data($result);
    }


     /**
     * 添加圈子
     * @return \think\response\Json
     */
    public function circle_add()
    {
        $params = $this->request->post();
        $add_res=CircleLogic::add($params);
        return $this->success('添加成功',[],1,1);
    }

    public function circle_cate_add()
    {
        $params = $this->request->post();
        CircleCateLogic::add($params);
        return $this->success('添加成功',[],1,1);
    }


    /** 
     * @notes 编辑圈子
     * @return \think\response\Json
     */
    public function circle_edit()
    {
        $params = $this->request->post();
        CircleLogic::edit($params);
        return $this->success('编辑成功',[],1,1);
    }

    public function circle_cate_edit()
    {
        $params = $this->request->post();
        CircleCateLogic::edit($params);
        return $this->success('编辑成功',[],1,1);
    }

    /**
     * @notes 删除文章/帮助
     * @return \think\response\Json
     */
    public function circle_delete()
    {
        $params = $this->request->post();
        CircleLogic::delete($params);
        return $this->success('删除成功',[],1,1);
    }

    public function circle_cate_delete()
    {
        $params = $this->request->post();
        CircleCateLogic::delete($params);
        return $this->success('删除成功',[],1,1);
    }

    /**
     * @notes 修改显示
     * @return \think\response\Json
     */

    public function circle_show()
    {
        $params = $this->request->post();
        CircleLogic::show($params);
        return $this->success('修改成功',[],1,1);
    }

    /**
     * @notes 修改状态
     * @return \think\response\Json
     */
     public function circle_status()
     {
         $params = $this->request->post();
         CircleLogic::status($params);
         return $this->success('修改成功',[],1,1);
     }

    
}