<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\service;

use app\common\enum\PayEnum;
use app\common\enum\UserTerminalEnum;
use app\common\model\PayConfig;

/**
 * 微信配置类
 * Class WeChatConfigService
 * @package app\common\service
 */
class WeChatConfigService
{
    /**
     * 获取小程序配置
     * @return array
     */
    public static function getMnpConfig()
    {
        $config = [
            'app_id' => ConfigService::get('mini_program', 'app_id',''),
            'secret' => ConfigService::get('mini_program', 'app_secret','' ),
            'mch_id' => ConfigService::get('mini_program', 'mch_id'),
            'key' => ConfigService::get('mini_program', 'key'),
            'response_type' => 'array',
            'log' => [
                'level' => 'debug',
                'file' => '../runtime/log/wechat.log'
            ],
        ];
        return $config;
    }

    /**
     * 获取微信公众号配置
     * @return array
     */
    public static function getOaConfig()
    {
        $config = [
            'app_id' => ConfigService::get('official_account', 'app_id',''),
            'secret' => ConfigService::get('official_account', 'app_secret',''),
            'mch_id' => ConfigService::get('official_account', 'mch_id'),
            'key' => ConfigService::get('official_account', 'key'),
            'token' => ConfigService::get('official_account', 'token',''),
            'response_type' => 'array',
            'log' => [
                'level' => 'debug',
                'file' => '../runtime/log/wechat.log'
            ],
        ];
        return $config;
    }

    /**
     * 获取微信开放平台应用配置
     * @return array
     */
    public static function getOpConfig()
    {
        $config = [
            'app_id' => ConfigService::get('op', 'app_id'),
            'secret' => ConfigService::get('op', 'secret'),
            'response_type' => 'array',
            'log' => [
                'level' => 'debug',
                'file' => '../runtime/log/wechat.log'
            ],
        ];
        return $config;
    }





    //根据用户客户端不同获取不同的微信配置
    public static function getWechatConfigByTerminal($terminal)
    {
            // 'mch_id' => 1402706402,
            // 商户证书
            // 'private_key' => '/www/wwwroot/lesns.com/runtime/certificate/42c01158022ba6aedec37b4a9a8d4001.pem',
            // 'certificate' => '/www/wwwroot/lesns.com/runtime/certificate/4bb98bbd3bc9cd0c57a9e17629921a05.pem',
        switch ($terminal) {
            case UserTerminalEnum::WECHAT_MMP:
                $appid = ConfigService::get('mini_program', 'app_id');
                $secret = ConfigService::get('mini_program', 'app_secret');
                $notify_url = (string)url('pay/notifyMnp', [], false, true);
                break;
            case UserTerminalEnum::WECHAT_OA:
            case UserTerminalEnum::PC:
            case UserTerminalEnum::H5:
                $appid = ConfigService::get('official_account', 'app_id');
                $secret = ConfigService::get('official_account', 'app_secret');
                $notify_url = (string)url('pay/notifyOa', [], false, true);
                break;
            case UserTerminalEnum::ANDROID:
            case UserTerminalEnum::IOS:
                $appid = ConfigService::get('open_platform', 'app_id');
                $secret = ConfigService::get('open_platform', 'app_secret');
                $notify_url = (string)url('pay/notifyApp', [], false, true);
                break;
            default:
                $appid = '';
                $secret = '';
        }
        $pay = PayConfig::where(['pay_way' => PayEnum::WECHAT_PAY])->findOrEmpty()->toArray();
        //判断是否已经存在证书文件夹，不存在则新建
        if (!file_exists(app()->getRootPath().'runtime/certificate')) {
            mkdir(app()->getRootPath().'runtime/certificate', 0775, true);
        }
        //写入文件
        $apiclient_cert = $pay['config']['apiclient_cert'] ?? '';
        $apiclient_key = $pay['config']['apiclient_key'] ?? '';
        // dd($apiclient_key);
        // dd($apiclient_cert);
        $cert_path = app()->getRootPath().'runtime/certificate/'.md5($apiclient_cert).'.pem';
        $key_path = app()->getRootPath().'runtime/certificate/'.md5($apiclient_key).'.pem';
        if (!file_exists($cert_path)) {
            $fopen_cert_path = fopen($cert_path, 'w');
            fwrite($fopen_cert_path, $apiclient_cert);
            fclose($fopen_cert_path);
        }
        if (!file_exists($key_path)) {
            $fopen_key_path = fopen($key_path, 'w');
            fwrite($fopen_key_path, $apiclient_key);
            fclose($fopen_key_path);
        }

        // dd($pay['config']);
        // dd($pay['config']['pay_sign_key']);
        $config = [
            // 'app_id' => $pay['config']['app_id'] ?? '',
            'app_id'=>$appid,
            'secret' => $secret,
            'mch_id' => $pay['config']['mch_id'] ?? '',
            'key' => $pay['config']['pay_sign_key'] ?? '',//v2密钥
            'secret_key'=>$pay['config']['pay_sign_key'],//v3密钥
            // 'cert_path' => $cert_path,
            // 'key_path' => $key_path,
            
            'private_key'=>$key_path,
            'certificate'=>$cert_path,

            'response_type' => 'array',
            'log' => [
                'level' => 'debug',
                'file' => '../runtime/log/wechat.log'
            ],
            'notify_url' => $notify_url
        ];

        return $config;
    }

}