<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\service;

use app\common\cache\RegionCache;
use app\common\model\Region;

class RegionService
{
    /**
     * @notes 获取地址
     * @param $val
     * @param string $address
     * @return mixed|string
     */
    public static function getAddress($val, $address = '')
    {
        $regionCache = new RegionCache();
        $region = $regionCache->getRegion();
        if(!$region) { // 无缓存
            $region = Region::column('id,name', 'id');
            $regionCache->setRegion($region, 3600);
        }
        // 有缓存
        if(is_array($val)) { // 数组
            $temp = '';
            foreach($val as $v) {
                $temp .= isset($region[$v]) ? $region[$v]['name'] : '';
            }
            return $temp.$address;
        }

        // 非数组
        return $region[$val] ? $region[$val]['name'] : '';
    }
}