<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */



namespace app\common\service;


use think\facade\Cache;

class FileService
{
    /**
     * @notes 补全路径
     * @param $uri
     * @param bool $type
     * @return string
     */
    public static function getFileUrl($uri = '', $type = false)
    {
//        if(empty(trim($uri))) return $uri;
        if (strstr($uri, 'http://'))  return $uri;
        if (strstr($uri, 'https://')) return $uri;
        // dd($uri);
        $default = '';
        // $default = Cache::get('STORAGE_DEFAULT');
        // if (!$default) {
        //     $default = ConfigService::get('storage', 'default', 'local');
        //     Cache::set('STORAGE_DEFAULT', $default);
        // }
        $uri_list = explode('/',$uri);
        // echo '<pre>';
        // print_r($uri_list);
        if($uri !=''){
            $default = 'local';
            if($uri_list[0] == 'oss'){
                // oss资源
                $default = $uri_list[1];
            }
        }
        

        if ($default === 'local') {
            if($type == 'share') {
                return public_path(). $uri;
            }
            return request()->domain() . '/' . $uri;
        } else {
            // dd($default);
            $storage = ConfigService::get('storage', $default);
            if (!$storage) {
                $storage = ConfigService::get('storage', $default);
                Cache::set('STORAGE_ENGINE', $storage);
            }
            if(!empty($default)){
                return $storage ?  $storage['domain'] . '/' . $uri : $uri;
            }else{
                if($storage['default']=='local'){
                    return '';
                }
                if(empty($default)){
                    return $storage ?  $storage[$storage['default']]['domain'] . '/' . $uri : $uri;
                }
            };

            
           
        


            // $default = ConfigService::get('storage', 'default', 'local');
            // $oss_list = [
            //     'default'=> $default,
            //     'list'=>[
            //         'aliyun'=> ConfigService::get('storage', 'aliyun')['domain'],
            //         'qiniu'=>  ConfigService::get('storage', 'qiniu')['domain'],
            //         'qcloud'=>  ConfigService::get('storage', 'qcloud')['domain'],
            //     ]
            // ];
            // return $oss_list;
        }
    }

    /**
     * @notes 转相对路径
     * @param $uri
     * @return mixed
     */
    public static function setFileUrl($uri)
    {
        $default = ConfigService::get('storage', 'default', 'local');
        if ($default === 'local') {
            $domain = request()->domain();
            return str_replace($domain.'/', '', $uri);
        } else {
            $storage = ConfigService::get('storage', $default);
            return str_replace($storage['domain'].'/', '', $uri);
        }
    }
}