<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

// use app\common\enum\DeliveryEnum;
// use app\common\enum\OrderEnum;
// use app\common\enum\PayEnum;
// use app\common\enum\UserTerminalEnum;
// use app\common\enum\YesNoEnum;
// use app\common\service\ConfigService;
// use app\common\service\FileService;
// use app\common\service\RegionService;
// use app\api\logic\Order\OrderBtnLogic;
// use think\model\concern\SoftDelete;

/**
 * 订单模型
 * Class Order
 * @package app\common\model
 */
class TwoOrder extends BaseModel
{
    // use SoftDelete;

    protected $deleteTime = 'delete_time';

    protected $json = ['address'];


    /**
     * @notes 关联订单商品
     * @return \think\model\relation\hasOne
     */
    public function orderGoods()
    {
        return $this->hasOne(TwoOrderGoods::class, 'order_id', 'id');
    }

    /**
     * 快递公司
     * @return \think\model\relation\HasOne
     */
    public function express()
    {
        return $this->hasOne(Express::class, 'id', 'express_id');
    }

    /**
     * @notes 一对多关联订单日志
     * @return \think\model\relation\HasMany
     */
    // public function orderLog()
    // {
    //     return $this->hasMany(OrderLog::class, 'order_id', 'id');
    // }

    /**
     * @notes 关联自提门店模型
     * @return \think\model\relation\HasOne
     */
    // public function selffetchShop()
    // {
    //     return $this->hasOne(SelffetchShop::class, 'id', 'selffetch_shop_id');
    // }

    /**
     * @notes 用户关联模型
     * @return \think\model\relation\HasOne
     * @author lgp
     * @date 2023/2/16 18:45
     */
    public function user()
    {
        return $this->hasOne(User::class,'id','user_id')->field('id,nickname,avatar');
    }

    // public function verification()
    // {
    //     return $this->hasOne(Verification::class,'order_id','id');
    // }

    /**
     * @notes 通过订单id获取用户订单
     * @param $id
     * @param $userId
     * @return Order|array|\think\Model
     */
    public function getUserOrderById($id, $userId)
    {
        return $this->with(['order_goods'])->where([['id','=',$id]])->whereOr([['user_id','=',$userId], ['sell_user_id','=',$userId]])->findOrEmpty();
    }

    /**
     * @notes 通过订单id获取订单
     * @param $id
     * @return Order|array|\think\Model
     */
    // public function getOrderById($id)
    // {
    //     return $this->with(['order_goods'])->where(['id' => $id])->findOrEmpty();
    // }


    /**
     * @notes 筛选门店
     * @param $query
     * @param $value
     * @param $data
     * @author lgp
     * @date 2022/4/29 17:40
     */
    // public function searchShopIdAttr($query,$value,$data){
    //     if($value){
    //         $query->where('selffetch_shop_id', '=', $value);

    //     }
    // }
    /**
     * @notes 搜索器-用户id
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchUserIdAttr($query, $value, $data)
    // {
    //     $query->where('user_id', '=', $value);
    // }


    /**
     * @notes 搜索器-订单类型
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchOrderTypeAttr($query, $value, $data)
    // {
    //     switch ($value ?? '') {
    //         //待支付
    //         case 'pay':
    //             $query->where('order_status', '=', OrderEnum::STATUS_WAIT_PAY);
    //             break;
    //         //待发货
    //         case 'delivery':
    //             $query->where('order_status', '=', OrderEnum::STATUS_WAIT_DELIVERY);
    //             break;
    //         //待收货
    //         case 'take':
    //             $query->where('order_status','=',OrderEnum::STATUS_WAIT_RECEIVE);
    //             break;
    //         //已完成
    //         case 'finish':
    //             $query->where('order_status', '=', OrderEnum::STATUS_FINISH);
    //             break;
    //         //已关闭
    //         case 'close':
    //             $query->where('order_status', '=', OrderEnum::STATUS_CLOSE);
    //             break;
    //     }
    // }


    /**
     * @notes 获取器-操作按钮
     * @param $value
     * @param $data
     * @return array
     */
    // public function getBtnAttr($value, $data)
    // {
    //     return OrderBtnLogic::getOrderBtn($this);
    // }

    /**
     * @notes 收货地址
     * @param $value
     * @param $data
     * @return mixed|string
     */
    // public function getDeliveryAddressAttr($value, $data)
    // {
    //     return RegionService::getAddress(
    //         [
    //             $data['address']->province ?? '',
    //             $data['address']->city ?? '',
    //             $data['address']->district ?? ''
    //         ],
    //         $data['address']->address ?? '',
    //     );
    // }

    /**
     * @notes 取消未支付订单时间
     * @param $value
     * @param $data
     * @return float|int|string
     */
    // public function getCancelUnpaidOrdersTimeAttr($value, $data)
    // {
    //     $end_time = '';
    //     if ($data['order_status'] == 0 && $data['pay_status'] == 0) {
    //         //系统取消待付款订单
    //         $systemCancel = ConfigService::get('transaction', 'cancel_unpaid_orders');
    //         if ($systemCancel == YesNoEnum::YES) {
    //             $systemCancelTime = ConfigService::get('transaction', 'cancel_unpaid_orders_times');
    //             $end_time = $data['create_time'] + ($systemCancelTime * 60);
    //         }
    //     }
    //     return $end_time;
    // }

    /**
     * @notes 订单类型获取器
     * @param $value
     * @param $data
     * @return array|mixed|string|string[]
     */
    // public function getOrderTypeDescAttr($value,$data)
    // {
    //     return OrderEnum::getOrderTypeDesc($data['order_type']);
    // }

    /**
     * @notes 订单状态获取器
     * @param $value
     * @param $data
     * @return string|string[]
     */
    // public function getOrderStatusDescAttr($value,$data)
    // {
    //     return OrderEnum::getOrderStatusDesc($data['order_status']);
    // }

    /**
     * @notes 支付状态获取器
     * @param $value
     * @param $data
     * @return string|string[]
     */
    // public function getPayStatusDescAttr($value,$data)
    // {
    //     return PayEnum::getPayStatusDesc($data['pay_status']);
    // }

    /**
     * @notes 订单来源获取器
     * @param $value
     * @param $data
     * @return string|string[]
     */
    // public function getOrderTerminalDescAttr($value,$data)
    // {
    //     return (new UserTerminalEnum)->getTermInalDesc($data['order_terminal']);
    // }

    /**
     * @notes 支付方式获取器
     * @param $value
     * @param $data
     * @return array|mixed|string|string[]
     */
    // public function getPayWayDescAttr($value,$data)
    // {
    //     return PayEnum::getPayDesc($data['pay_way']);
    // }

    /**
     * @notes 用户头像获取器
     * @param $value
     * @param $data
     * @return string
     */
    // public function getAvatarAttr($value,$data)
    // {
    //     return empty($value) ? '' : FileService::getFileUrl($value);
    // }

    /**
     * @notes 后台订单操作按钮获取器
     * @param $value
     * @param $data
     * @return array
     */
    // public function getAdminOrderBtnAttr($value, $data)
    // {
    //     return \app\adminapi\logic\order\OrderBtnLogic::getOrderBtn($this);
    // }

    /**
     * @notes 支付时间获取器
     * @param $value
     * @param $data
     */
    // public function getPayTimeAttr($value,$data)
    // {
    //     if ($value) {
    //         return date('Y-m-d H:i:s',$value);
    //     }
    //     return '——';
    // }

    /**
     * @notes 完成时间获取器
     * @param $value
     * @param $data
     * @return string
     */
    // public function getConfirmTakeTimeAttr($value,$data)
    // {
    //     if ($value) {
    //         return date('Y-m-d H:i:s',$value);
    //     }
    //     return '——';
    // }

    /**
     * @notes 配送状态获取器
     * @param $value
     * @param $data
     * @return string|string[]
     */
    // public function getExpressStatusDescAttr($value, $data)
    // {
    //     return DeliveryEnum::getDeliveryStatusDesc($data['express_status']);
    // }

    /**
     * @notes 配送方式获取器
     * @param $value
     * @param $data
     * @return string|string[]
     */
    // public function getDeliveryTypeDescAttr($value, $data)
    // {
    //     return DeliveryEnum::getDeliveryTypeDesc($data['delivery_type']);
    // }

    /**
     * @notes 配送时间获取器
     * @param $value
     * @param $data
     * @return string
     */
    // public function getExpressTimeAttr($value,$data)
    // {
    //     if ($value) {
    //         return date('Y-m-d H:i:s',$value);
    //     }
    //     return '——';
    // }


    /**
     * @notes 订单编号搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchOrderSnAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('o.sn','like', '%'.$value.'%');
    //     }
    // }

    /**
     * @notes 用户信息搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchUserInfoAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('u.nickname|u.sn|u.mobile','like', '%'.$value.'%');
    //     }
    // }

    /**
     * @notes 商品名称搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchGoodsNameAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('og.goods_name','like', '%'.$value.'%');
    //     }
    // }

    /**
     * @notes 收货人信息搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchContactInfoAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('o.address->contact|o.address->mobile','like', '%'.$value.'%');
    //     }
    // }

    /**
     * @notes 获取收货人
     * @param $value
     * @param $data
     * @return string
     * @author lgp
     * @date 2023/2/23 14:30
     */
    // public function getConsigneeAttr($value, $data)
    // {
    //     return $data['address']->contact ?? '';

    // }

    /**
     * @notes 获取收货人电话
     * @param $value
     * @param $data
     * @return string
     * @author lgp
     * @date 2023/2/23 14:30
     */
    // public function getMobileAttr($value,$data)
    // {
    //     return $data['address']->mobile ?? '';
    // }


    /**
     * @notes 订单来源搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchOrderTerminalAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('o.order_terminal','=', $value);
    //     }
    // }

    /**
     * @notes 后台订单类型搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchOrderTypeAdminAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('o.order_type','=', $value);
    //     }
    // }

    /**
     * @notes 支付方式搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchPayWayAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('o.pay_way','=', $value);
    //     }
    // }

    /**
     * @notes 支付状态搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchPayStatusAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('o.pay_status','=', $value);
    //     }
    // }

    /**
     * @notes 配送方式搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchDeliveryTypeAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('o.delivery_type','=', $value);
    //     }
    // }

    /**
     * @notes 时间段搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchTimeTypeAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->whereBetweenTime('o.'.$value, $data['start_time'], $data['end_time']);
    //     }
    // }

    /**
     * @notes 订单状态搜索器
     * @param $query
     * @param $value
     * @param $data
     */
    // public function searchOrderStatusAttr($query, $value, $data)
    // {
    //     if(isset($value) && $value != ''){
    //         $query->where('o.order_status','=', $value);
    //     }
    // }




    /**
     * @notes 获取器-操作按钮
     * @param $value
     * @param $data
     * @return array
     */
    // public function getBusinesseBtnAttr($value, $data)
    // {
    //     return \app\adminapi\logic\order\OrderBtnLogic::getBusinesseBtn($this);
    // }

}