<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\enum\AfterSaleEnum;
use app\common\service\FileService;
use think\model\concern\SoftDelete;

/**
 * 售后商品模型
 * Class AfterSaleGoods
 * @package app\common\model
 */
class AfterSaleGoods extends BaseModel
{
    use SoftDelete;

    /**
     * @notes 获取商品信息快照
     * @param $value
     * @return mixed
     */
    public function getGoodsSnapAttr($value)
    {
        $goodsSnap = OrderGoods::where('id', $value)->value('goods_snap');
      
        if(!empty($goodsSnap)) {
            // $goodsSnap = json_decode($goodsSnap, true);
            $goodsSnap['use_image'] = !empty($goodsSnap['spec_image']) ? $goodsSnap['spec_image'] : $goodsSnap['image'];
            $goodsSnap['use_image'] = FileService::getFileUrl($goodsSnap['use_image']);
        }
        return $goodsSnap;
    }
}