<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\listener\websocket;


use app\common\cache\ChatCache;
use think\facade\Log;

/**
 * 启动事件
 * Class Start
 * @package app\common\listener\websocket
 */
class Start
{
    public function handle($params)
    {
        echo '开始了Start';
        try{
            $prefix = config('project.websocket_prefix');
            if (empty($prefix)) {
                return true;
            }
            $redis = new ChatCache();
            $redis->del($redis->keys($prefix));
            return true;
        } catch (\Exception $e) {
            echo $e->getMessage();
            Log::write('swoole启动异常:'.$e->getMessage());
        }
    }
}