<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\enum;
/**
 * 微信错误信息枚举类
 * Class WechatErrorEnum
 * @package app\common\enum
 */
class WechatErrorEnum
{
    //公共错误码
    const COMMONCODE = [
        40001       => '无效accesstoken',
        40014       => '无效accesstoken',
        41001       => 'accesstoken不存在',
        42001       => 'accesstoken过期',
        45009       => '天级别频率限制，2种解决途径2选1: 1.到小程序mp-开发管理 - 接口设置 - 调用额度重置;2.调用限频重置API',
        47001       => '非 json 请求',
        61007       => '小程序尚未将对应的权限集授权给第三方平台',
        61004       => '第三方平台出口 IP 未设置',
        40066       => 'api的 url 不存在（一般情况下填错了）',
        48001       => '小程序未获得该接口权限',
        87014       => '存在违规内容',
        300000      => '瞬时请求频率过高，请降低频率重试',
        990001      => 'OPENID非法',
        990002      => 'OPENID非法',
        990004      => 'OPENID缺失',
        990005      => 'page_size超过上限',
        990007      => '参数缺失',
        990008      => '参数过长',
        990009      => '开始时间比结束时间大',
        990010      => '系统繁忙，请稍后重试',
    ];


    /**
     * @notes 获取微信的错误信息
     * @param bool $from
     * @return array|mixed|string
     * @throws \ReflectionException
     * @author lgp
     * @date 2022/6/9 16:42
     */
    public static function wechatErrorMessage($from = true){
        //通过反射拿当前的常量
        $constantsList= (new \ReflectionClass(__CLASS__))->getConstants();
        $errorList = [];
        foreach ($constantsList as $constant){
            $errorList = $errorList+$constant;
        }
        if(true === $from){
            return $errorList;
        }
        return $errorList[$from] ?? '';
    }

}