<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\cache;

class RegionCache extends BaseCache
{
    protected $tagName = 'region';

    /**
     * @notes 获取地址信息
     * @return false|mixed
     */
    public function getRegion()
    {
        $region = $this->get($this->tagName);
        if($region) {
            return $region;
        }
        return false;
    }

    /**
     * @notes 设置地填信息缓存
     * @param $data
     * @param $expire
     */
    public function setRegion($data, $expire)
    {
        $this->set($this->tagName, $data, $expire);
    }
}