<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\logic;

use app\common\enum\NoticeEnum;
use app\common\logic\BaseLogic;
use app\common\model\Config;
use app\common\model\Notice;
use app\common\service\ConfigService;
use app\common\service\FileService;

/**
 * 通知逻辑
 * Class NoticeLogic
 * @package app\api\logic
 */
class NoticeLogic extends BaseLogic
{
    /**
     * @notes 消息通知
     * @param $userId
     * @return array
     */
    public static function index($userId)
    {

        $system_notice_icon = ConfigService::get('default_image', 'system_notice_icon');
        $system_notice_icon = FileService::getFileUrl($system_notice_icon);

        $notice_collect_icon = ConfigService::get('default_image', 'notice_collect_icon');
        $notice_collect_icon = FileService::getFileUrl($notice_collect_icon);

        
        $notice_comment_icon = ConfigService::get('default_image', 'notice_comment_icon');
        $notice_comment_icon = FileService::getFileUrl($notice_comment_icon);


        $notice_follow_icon = ConfigService::get('default_image', 'notice_follow_icon');
        $notice_follow_icon = FileService::getFileUrl($notice_follow_icon);


        
        
        $data['collect'] = [
            'title' => '赞和收藏',
            'content' =>  '',
            'img' => $notice_collect_icon,
            'type' => 'collect',
            'unread'=>Notice::where(['user_id'=>$userId,'read'=>0,'scene_id'=>NoticeEnum::ARTICLE_COLLECT_NOTICE])->count(),
        ];
        $data['comment'] = [
            'title' => '评论和@',
            'content' =>  '',
            'img' => $notice_comment_icon,
            'type' => 'comment',
            'unread'=>Notice::where(['user_id'=>$userId,'read'=>0,'scene_id'=>NoticeEnum::ARTICLE_COMMENT_NOTICE])->count(),
        ];
        $data['follow'] = [
            'title' => '新增关注',
            'content' =>  '',
            'img' => $notice_follow_icon,
            'type' => 'follow',
            'unread'=>Notice::where(['user_id'=>$userId,'read'=>0,'scene_id'=>NoticeEnum::FOLLOW_NOTICE])->count(),
        ];

        // 最新系统消息
        $system = Notice::where('scene_id', 'in',  [
                NoticeEnum::ORDER_PAY_NOTICE,
                NoticeEnum::ORDER_SHIP_NOTICE,
                NoticeEnum::SELLER_ORDER_PAY_NOTICE,
                NoticeEnum::SELLER_REFUND_APPLY_NOTICE,
                NoticeEnum::REFUND_REFUSE_NOTICE,
                NoticeEnum::REFUND_SUCCESS_NOTICE 
            ])
            ->where(['user_id' => $userId, 'send_type' => NoticeEnum::SYSTEM])
            ->order('id desc')
            ->findOrEmpty()->toArray();

        
        $data['system'] = [
            'title' => '系统通知',
            'content' => $system['content'] ?? '',
            'img' => $system_notice_icon,
            'type' => 'system',
            'unread'=>Notice::where([
                ['read','=',0],
                ['user_id','=',$userId],
                ['scene_id','in',[
                    NoticeEnum::ORDER_PAY_NOTICE,
                    NoticeEnum::ORDER_SHIP_NOTICE,
                    NoticeEnum::SELLER_ORDER_PAY_NOTICE,
                    NoticeEnum::SELLER_REFUND_APPLY_NOTICE,
                    NoticeEnum::REFUND_REFUSE_NOTICE,
                    NoticeEnum::REFUND_SUCCESS_NOTICE,
                    NoticeEnum::ARTICLE_EXAMINE_NOTICE,
                ]]
            ])->count(),
        ];

        
        return array_values($data);
    }
}