<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

declare (strict_types=1);

namespace app\api\http\middleware;


class RequestEventMiddleware
{

    public function handle($request, \Closure $next)
    {
        $startTime = microtime(true);

        $result = $next($request);

        $duration = round(microtime(true) - $startTime, 3);

        // 判断插件安装并启用
        if(isActivePluginByPluginName("logrequest")){
            event('RequestHandled', [
                'time' => date('Y-m-d H:i:s'),
                'ip' => $request->ip(),
                'method' => $request->method(),
                'url' => $request->url(),
                'params' => $request->param(),
                'status' => $result->getCode(),
                'duration' => $duration . 's'
            ]);
        };

        return $result;
    }
}