<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;

use app\api\logic\NoticeLogic;

/**
 * 消息控制器
 * Class NoticeController
 * @package app\api\controller
 */
class Notice extends BaseShopController
{

    public array $notNeedLogin = ['index'];

    /**
     * @notes 消息中心
     * @return \think\response\Json
     */
    public function index()
    {
        $result = NoticeLogic::index($this->userId);
        return $this->data($result);
    }

    /**
     * @notes 通知列表
     * @return \think\response\Json
     */
    public function lists()
    {
        $result = $this->dataLists();
        $raw = $result->getContent();
        $json = json_decode($raw, 1);

        foreach($json['data']['lists'] as &$item) {
            if (!isset($item['from_user'])) {
                continue;
            }

            $item['from_user']['is_followed'] = !!\app\common\model\UserFollow::where('user_id', $this->userId)->where('follow_user_id', $item['from_user']['id'])->find();
            $item['from_user']['is_fans'] = !!\app\common\model\UserFollow::where('follow_user_id', $this->userId)->where('user_id', $item['from_user']['id'])->find();
            $item['from_user']['location'] = \app\common\model\User::where('id', $item['from_user']['id'])->value('ip_address');
        }
        
        return json($json);
    }
}