<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */
namespace app\api\controller;

use EasyWeChat\Factory;


class Easywechat
{
	protected static $instance;
	
	/**
	 * 单例
	 * @param array $options 
	 * @return https://easywechat.com/5.x
	 */
	public static function app($type = 'applet')
	{
	    if (is_null(self::$instance)) {
			if($type == 'applet'){
				self::$instance = Factory::miniProgram(self::applet());
			}else if($type == 'official'){
				self::$instance = Factory::officialAccount(self::official());
			}
	    }
	    return self::$instance;
	}
	
	public static function applet()
	{
		// $config = get_addon_config('wanlshop');
		$data =[
			// 'app_id' => $config['mp_weixin']['appid'],
			// 'secret' => $config['mp_weixin']['appsecret'],

            'app_id' => 'wx75a732ad8a5eaa11',
			'secret' => '1c2f1f337b806edcfc3fb6c4d973a35edd',
		
			// 下面为可选项
			// 指定 API 调用返回结果的类型：array(default)/collection/object/raw/自定义类名
			'response_type' => 'array',
		
			// 'log' => [
			//     'level' => 'debug',
			//     'file' => ROOT_DIR . '/../runtime/log/wechat/mini.log',
			// ]
		];
        // dd($data);
        return $data;
	}
	
	public static function official()
	{
        echo 99;die;
	    $config = get_addon_config('wanlshop');
	
	    return [
	        /**
	         * 账号基本信息，请从微信公众平台/开放平台获取
	         */
	        'app_id'        => $config['sdk_qq']['gz_appid'], // AppID
	        'secret'        => $config['sdk_qq']['gz_secret'], // AppSecret
	        'token'         => $config['sdk_qq']['gz_token'], // Token
	        'aes_key'       => $config['sdk_qq']['gz_aeskey'], // EncodingAESKey，安全模式下请一定要填写！！！
	
	        /**
	         * 指定 API 调用返回结果的类型：array(default)/collection/object/raw/自定义类名
	         * 使用自定义类名时，构造函数将会接收一个 `EasyWeChat\Kernel\Http\Response` 实例
	         */
	        'response_type' => 'array',
	
	        /**
	         * 日志配置
	         *
	         * level: 日志级别, 可选为：debug/info/notice/warning/error/critical/alert/emergency
	         * path：日志文件位置(绝对路径!!!)，要求可写权限
	         */
	        'log'           => [
	            'default'  => 'dev', // 默认使用的 channel，生产环境可以改为下面的 prod
	            'channels' => [
	                // 测试环境
	                'dev'  => [
	                    'driver' => 'single',
	                    'path'   => ROOT_PATH . '/runtime/log/wechat/mp.log',
	                    'level'  => 'debug',
	                ],
	                // 生产环境
	                'prod' => [
	                    'driver' => 'daily',
	                    'path'   => ROOT_PATH . '/runtime/log/wechat/mp.log',
	                    'level'  => $config['sdk_qq']['gz_loglevel'],
	                ],
	            ],
	        ],
	
	        /**
	         * 接口请求相关配置，超时时间等，具体可用参数请参考：
	         * http://docs.guzzlephp.org/en/stable/request-config.html
	         *
	         * - retries: 重试次数，默认 1，指定当 http 请求失败时重试的次数。
	         * - retry_delay: 重试延迟间隔（单位：ms），默认 500
	         * - log_template: 指定 HTTP 日志模板，请参考：https://github.com/guzzle/guzzle/blob/master/src/MessageFormatter.php
	         */
	        'http'          => [
	            'max_retries' => 1,
	            'retry_delay' => 500,
	            'timeout'     => 5.0,
	            // 'base_uri' => 'https://api.weixin.qq.com/', // 如果你在国外想要覆盖默认的 url 的时候才使用，根据不同的模块配置不同的 uri
	        ],
	
	        /**
	         * OAuth 配置
	         *
	         * scopes：公众平台（snsapi_userinfo / snsapi_base），开放平台：snsapi_login
	         * callback：OAuth授权完成后的回调页地址
	         */
	        'oauth'         => [
	            'scopes'   => ['snsapi_userinfo'],
	            'callback' => $config['ini']['appurl']. $config['sdk_qq']['gz_callback'],
	        ],
	    ];
	}
	
	
	
	public static function pay()
	{
	    $config = get_addon_config('wanlshop');
	
	    return [
	        /**
	         * 账号基本信息，请从微信公众平台/开放平台获取
	         */
	        'app_id'        => $config['sdk_qq']['gz_appid'], // AppID
			'mch_id'        => $config['sdk_qq']['mch_id'],
			'key'           => $config['sdk_qq']['key'],   // API 密钥
	
			// 如需使用敏感接口（如退款、发送红包等）需要配置 API 证书路径(登录商户平台下载 API 证书)
			// 'cert_path'          => 'path/to/your/cert.pem', // XXX: 绝对路径！！！！
			// 'key_path'           => 'path/to/your/key',      // XXX: 绝对路径！！！！
	
			'notify_url'    => $config['ini']['appurl']. $config['sdk_qq']['gz_notify_url'],     // 你也可以在下单时单独设置来想覆盖它
	    ];
	}
	
	public static function appConfig()
	{
		return [];
	}
	
	
}