<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\validate\user;
use app\common\{
    model\User,
    validate\BaseValidate
};

/**
 * 调整用户钱包验证器
 * Class AdjustUserEarnings
 * @package app\adminapi\validate\user
 */
class adjustUserWallet extends BaseValidate
{
    protected $rule = [
        'user_id'   => 'require',
        'type'      => 'require|in:1,2,3',
        'action'    => 'require|in:0,1',
        'num'       => 'require|gt:0|checkNum',
        'remark'    => 'max:128',
    ];
    protected $message = [
        'id.require'        => '请选择用户',
        'type.require'      => '请选择变动类型',
        'type.in'           => '变动类型错误',
        'action.require'    => '请选择调整类型',
        'action.in'         => '调整类型错误',
        'num.require'       => '请输入调整数量',
        'num.gt'            => '调整余额必须大于零',
        'remark'            => '备注不可超过128个符号',
    ];


    protected function checkNum($vaule,$rule,$data){

        $user = User::find($data['user_id']);

        if(empty($user)){
            return '用户不存在';
        }

        if(1 == $data['action']){
            return true;
        }
        switch ($data['type']){
            case 1:
                $surplusMoeny = $user->user_money - $vaule;
                if($surplusMoeny < 0){
                    return '用户可用余额仅剩'.$user->user_money;
                }
                break;
            case 2:
                $surplusMoeny = $user->user_earnings - $vaule;
                if($surplusMoeny < 0){
                    return '用户可提现金额仅剩'.$user->user_earnings;
                }
                break;
        }

        return true;
    }


}