<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate\settings\pay;


use app\common\enum\PayEnum;
use app\common\model\PayConfig;
use app\common\validate\BaseValidate;

class PayConfigValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require|checkId',
        'name' => 'require|checkName',
        'icon' => 'require',
        'sort' => 'require|number|max:5',
    ];

    protected $message = [
        'id.require' => 'id不能为空',
        'name.require' => '支付名称不能为空',
        'icon.require' => '支付图标不能为空',
        'sort.require' => '排序不能为空',
        'sort,number' => '排序必须是纯数字',
        'sort.max' => '排序最大不能超过五位数',
    ];

    public function sceneGet()
    {
        return $this->only(['id'])
            ->remove('id','checkId');
    }

    /**
     * @notes 检查ID是否存在
     * @param $value
     * @param $rule
     * @param $data
     * @return bool|string
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function checkId($value,$rule,$data)
    {
        $result = PayConfig::where('id',$value)->find();
        if (empty($result)) {
            return '支付方式不存在';
        }
        if ($result['pay_way'] == PayEnum::WECHAT_PAY) {
            if (!isset($data['interface_version']) || empty($data['interface_version'])) {
                return '微信支付接口版本不能为空';
            }
            if (!isset($data['merchant_type']) || empty($data['merchant_type'])) {
                return '商户类型不能为空';
            }
            if (!isset($data['mch_id']) || empty($data['mch_id'])) {
                return '微信支付商户号不能为空';
            }
            if (!isset($data['pay_sign_key']) || empty($data['pay_sign_key'])) {
                return '商户API密钥不能为空';
            }
            if (!isset($data['apiclient_cert']) || empty($data['apiclient_cert'])) {
                return '微信支付证书不能为空';
            }
            if (!isset($data['apiclient_key']) || empty($data['apiclient_key'])) {
                return '微信支付证书密钥不能为空';
            }
        }
        if ($result['pay_way'] == PayEnum::ALI_PAY) {
            if (!isset($data['mode']) || empty($data['mode'])) {
                return '模式不能为空';
            }
            if (!isset($data['merchant_type']) || empty($data['merchant_type'])) {
                return '商户类型不能为空';
            }
            if (!isset($data['app_id']) || empty($data['app_id'])) {
                return '应用ID不能为空';
            }
            if (!isset($data['private_key']) || empty($data['private_key'])) {
                return '应用私钥不能为空';
            }
            if (!isset($data['ali_public_key']) || empty($data['ali_public_key'])) {
                return '支付宝公钥不能为空';
            }
        }
        return true;
    }

    /**
     * @notes 检查支付名称是否已存在
     * @param $value
     * @param $rule
     * @param $data
     */
    public function checkName($value,$rule,$data)
    {
        $result = PayConfig::where('name', $value)->where('id','<>', $data['id'])->findOrEmpty();
        if (!$result->isEmpty()) {
            return '支付名称已存在';
        }
        return true;
    }
}