<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\settings\delivery;


use app\common\enum\DefaultEnum;
use app\common\logic\BaseLogic;
use app\common\model\Express;
use app\common\service\FileService;

class ExpressLogic extends BaseLogic
{
    /**
     * @notes 添加快递公司
     * @param $params
     */
    public function add($params)
    {
        $express = new Express;
        $express->name = $params['name'];
        $express->icon = $params['icon'] ? FileService::setFileUrl($params['icon']) : '';
        $express->code = $params['code'] ?? '';
        $express->code100 = $params['code100'] ?? '';
        $express->codebird = $params['codebird'] ?? '';
        $express->sort = (isset($params['sort']) && !empty($params['sort'])) ? $params['sort'] : DefaultEnum::SORT;
        return $express->save();
    }

    /**
     * @notes 编辑快递公司
     * @param $params
     * @return bool
     */
    public function edit($params)
    {
        $express = Express::find($params['id']);
        $express->name = $params['name'];
        $express->icon = FileService::setFileUrl($params['icon']);
        $express->code = $params['code'];
        $express->code100 = $params['code100'];
        $express->codebird = $params['codebird'];
        $express->sort = $params['sort'];
        return $express->save();
    }

    /**
     * @notes 删除快递公司
     * @param $params
     */
    public function del($params)
    {
        return Express::destroy($params['id']);
    }

    /**
     * @notes 查看快递公司详情
     * @param $params
     */
    public function detail($params)
    {
        return Express::field('id,name,icon,code,code100,codebird,sort')->find($params['id'])->toArray();
    }
}