<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\goods;


use app\common\enum\DefaultEnum;
use app\common\model\GoodsSupplierCategory;

class GoodsSupplierCategoryLogic
{
    /**
     * @notes 添加供应商分类
     * @param $params
     * @return bool
     */
    public function add($params)
    {
        $goods_supplier_category = new GoodsSupplierCategory;
        $goods_supplier_category->name = $params['name'];
        $goods_supplier_category->sort = (isset($params['sort']) && !empty($params['sort'])) ? $params['sort'] : DefaultEnum::SORT;
        return $goods_supplier_category->save();
    }

    /**
     * @notes 删除供应商分类
     * @param $params
     * @return bool
     */
    public function del($params)
    {
        return GoodsSupplierCategory::destroy($params['id']);
    }

    /**
     * @notes 编辑供应商分类
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function edit($params)
    {
        $goods_supplier_category = GoodsSupplierCategory::find($params['id']);
        $goods_supplier_category->name = $params['name'];
        $goods_supplier_category->sort = $params['sort'];
        return $goods_supplier_category->save();
    }

    /**
     * @notes 查看供应商分类详情
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail($params)
    {
        return GoodsSupplierCategory::find($params['id'])->toArray();
    }
}