<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic;


use app\common\logic\BaseLogic;
use app\common\model\Footprint;
use app\common\service\ConfigService;

class FootprintLogic extends BaseLogic
{
    /**
     * @notes 设置足迹气泡
     */
    public static function setConfig($params)
    {
        ConfigService::set('footprint', 'status', $params['status']);
        ConfigService::set('footprint', 'duration', $params['duration']);
        ConfigService::set('footprint', 'pages', json_encode($params['pages']));
    }

    /**
     * @notes 获取足迹气泡配置
     */
    public static function getConfig()
    {
        return [
            'status' => ConfigService::get('footprint', 'status', 1),
            'duration' => ConfigService::get('footprint', 'duration', 60),
            'pages' => ConfigService::get('footprint', 'pages', [1, 2]),
        ];
    }


    /**
     * @notes 足迹气泡列表
     */
    public static function lists()
    {
        return Footprint::select()->toArray();
    }


    /**
     * @notes 修改汽泡状态
     */
    public static function status($id)
    {
        $record = Footprint::find($id);
        $record->status = $record->status ? 0 : 1;
        $record->save();
    }
}
