<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic;

use app\common\enum\ArticleEnum;
use app\common\enum\DefaultEnum;
use app\common\enum\YesNoEnum;
use app\common\logic\BaseLogic;
use app\common\model\Article;
use app\common\model\ArticleComment;
use app\common\model\Topic;
use app\common\model\TopicArticle;
use app\common\service\FileService;

class ArticleLogic extends BaseLogic
{

 

    /**
     * @notes 查看文章/帮助详情
     * @param $params
     * @return array
     */
    public static function detail($params)
    {
        $data =Article::with(['user','circle'])->append(['comment_num' ,'collect_num' ])->field('*')->findOrEmpty($params['id'])->toArray();
        return  $data;
    }

    /**
     * @notes 编辑文章/帮助
     * @param $params
     */
    public static function edit($params)
    {
        $image = isset($params['image']) && !empty($params['image']) ? FileService::setFileUrl($params['image']) : '';
        
        if(!empty($image)){
            $image = implode(',',$image);
        }

        $data = [
            // 'id' => $params['id'],
            'title' => $params['title'],
            // 'cid' => $params['cid'],
            'synopsis' => $params['synopsis'] ?? '',
            'image' => $image,
            'video'=>$params['video'] ?? '',
            'video_cover'=>$params['video_cover'] ?? '',
            'content' => $params['content'] ?? '',
            'sort' => $params['sort'] ?? DefaultEnum::SORT,
            'status' => $params['status'] ?? YesNoEnum::YES,
        ];

        Article::update($data,['id' => $params['id']]);
    }

        /**
     * @notes 添加文章/帮助
     * @param $params
     */
    public static function add($params)
    {
        $image = isset($params['image']) && !empty($params['image']) ? FileService::setFileUrl($params['image']) : '';

        $data = [
            'circle_id' => $params['circle_id'],
            'title' => $params['title'],
            'user_id' => $params['user_id'],
            'synopsis' => $params['synopsis'] ?? '',
            'image' => $image,
            'content' => $params['content'] ?? '',
            'sort' => $params['sort'] ?? DefaultEnum::SORT,
            'status' => $params['status'] ?? YesNoEnum::YES,
        ];

        Article::create($data);
    }

    /**
     * @notes 删除文章/帮助
     * @param $params
     */
    public static function delete($params)
    {
        Article::destroy($params['id']);
    }

    /**
     * @notes 修改是否显示状态
     * @param $params
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function status($params)
    {
        $article = Article::find($params['id']);
        $article->save([ $params['func'] => $params['status']]);
    }



    /**
     * @notes 删除帖子
     * @param $params
     */
    public static function comment_delete($params)
    {
        ArticleComment::destroy($params['id']);
    }


    /**
     * @notes 删除话题
     * @param $params
     */
    public static function topic_delete($params)
    {
        Topic::delete($params['id']);
    }

    
}