<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\goods;


use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\settings\goods\GoodsSettingsLogic;
use app\adminapi\validate\settings\goods\GoodsSettingsValidate;

class GoodsSettings extends BaseAdminController
{
    /**
     * @notes 设置商品配置
     */
    public function setConfig()
    {
        $params = (new GoodsSettingsValidate())->post()->goCheck();
        (new GoodsSettingsLogic())->setConfig($params);
        return $this->success('设置成功',[],1, 1);
    }

    /**
     * @notes 查看商品配置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $result = (new GoodsSettingsLogic())->getConfig();
        return $this->success('获取成功',$result);
    }


}